/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WinBuildVersionKt;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u000f\u0010\u0000\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\u0010\u0002\u001a\u000f\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"getWinBuildNumber", "", "()Ljava/lang/Long;", "getWinBuildNumberInternal", "intellij.platform.util"})
public final class WinBuildVersionKt {
    private static final Long getWinBuildNumberInternal() {
        try {
            String string2 = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "CurrentBuildNumber");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"registryGetStringValue(W\u2026    \"CurrentBuildNumber\")");
            return Long.parseLong(string2);
        }
        catch (Exception e) {
            if (e instanceof NumberFormatException || e instanceof Win32Exception) {
                Logger.getInstance(SystemInfo.class).warn("Bad win version", e);
                return null;
            }
            throw e;
        }
    }

    @Nullable
    public static final Long getWinBuildNumber() {
        return (Long)LazyKt.lazy((Function0)getWinBuildNumber.1.INSTANCE).getValue();
    }

    public static final /* synthetic */ Long access$getWinBuildNumberInternal() {
        return WinBuildVersionKt.getWinBuildNumberInternal();
    }
}

