/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.SafeJdomFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.AttributeList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SafeStAXStreamBuilder {
    public static final SafeJdomFactory FACTORY = new SafeJdomFactory.BaseSafeJdomFactory();

    static Document buildDocument(@NotNull XMLStreamReader2 stream) throws XMLStreamException {
        int state;
        if (stream == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(0);
        }
        if (7 != (state = stream.getEventType())) {
            throw new XMLStreamException("JDOM requires that XMLStreamReaders are at their beginning when being processed.");
        }
        Document document = new Document();
        while (state != 8) {
            switch (state) {
                case 7: {
                    document.setBaseURI(stream.getLocation().getSystemId());
                    document.setProperty("ENCODING_SCHEME", stream.getCharacterEncodingScheme());
                    document.setProperty("STANDALONE", String.valueOf(stream.isStandalone()));
                    document.setProperty("ENCODING", stream.getEncoding());
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    document.setRootElement(SafeStAXStreamBuilder.processElementFragment(stream, true, true, FACTORY));
                    break;
                }
                case 4: {
                    String badTxt = stream.getText();
                    if (Verifier.isAllXMLWhitespace(badTxt)) break;
                    throw new XMLStreamException("Unexpected XMLStream event at Document level: CHARACTERS (" + badTxt + ")");
                }
                default: {
                    throw new XMLStreamException("Unexpected XMLStream event at Document level:" + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end-of-XMLStreamReader");
        }
        return document;
    }

    public static Element build(@NotNull XMLStreamReader2 stream, boolean isIgnoreBoundaryWhitespace, boolean isNsSupported, @NotNull SafeJdomFactory factory) throws XMLStreamException {
        int state;
        if (stream == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(2);
        }
        if ((state = stream.getEventType()) != 7) {
            throw new XMLStreamException("JDOM requires that XMLStreamReaders are at their beginning when being processed");
        }
        Element rootElement = null;
        while (state != 8) {
            switch (state) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    break;
                }
                case 1: {
                    rootElement = SafeStAXStreamBuilder.processElementFragment(stream, isIgnoreBoundaryWhitespace, isNsSupported, factory);
                    break;
                }
                default: {
                    throw new XMLStreamException("Unexpected XMLStream event " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end-of-XMLStreamReader");
        }
        if (rootElement == null) {
            return new Element("empty");
        }
        return rootElement;
    }

    @NotNull
    public static Element processElementFragment(@NotNull XMLStreamReader2 reader, boolean isIgnoreBoundaryWhitespace, boolean isNsSupported, @NotNull SafeJdomFactory factory) throws XMLStreamException {
        Element fragment;
        if (reader == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(4);
        }
        Element current2 = fragment = SafeStAXStreamBuilder.processElement(reader, isNsSupported, factory);
        int depth = 1;
        block8: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element tmp = SafeStAXStreamBuilder.processElement(reader, isNsSupported, factory);
                    current2.addContent(tmp);
                    current2 = tmp;
                    ++depth;
                    continue block8;
                }
                case 2: {
                    current2 = current2.getParentElement();
                    --depth;
                    continue block8;
                }
                case 12: {
                    current2.addContent(factory.cdata(reader.getText()));
                    continue block8;
                }
                case 6: {
                    if (isIgnoreBoundaryWhitespace) continue block8;
                    current2.addContent(factory.text(reader.getText()));
                    continue block8;
                }
                case 4: {
                    if (isIgnoreBoundaryWhitespace && reader.isWhiteSpace()) continue block8;
                    current2.addContent(factory.text(reader.getText()));
                    continue block8;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block8;
                }
            }
            throw new XMLStreamException("Unexpected XMLStream event " + reader.getEventType(), reader.getLocation());
        }
        Element element = fragment;
        if (element == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(5);
        }
        return element;
    }

    @NotNull
    private static Element processElement(@NotNull XMLStreamReader2 reader, boolean isNsSupported, @NotNull SafeJdomFactory factory) {
        if (reader == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(6);
        }
        if (factory == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(7);
        }
        Element element = factory.element(reader.getLocalName(), isNsSupported ? Namespace.getNamespace(reader.getPrefix(), reader.getNamespaceURI()) : Namespace.NO_NAMESPACE);
        int attributeCount = reader.getAttributeCount();
        if (attributeCount != 0) {
            AttributeList list = element.initAttributeList(attributeCount);
            for (int i2 = 0; i2 < attributeCount; ++i2) {
                list.doAdd(factory.attribute(reader.getAttributeLocalName(i2), reader.getAttributeValue(i2), isNsSupported ? Namespace.getNamespace(reader.getAttributePrefix(i2), reader.getAttributeNamespace(i2)) : Namespace.NO_NAMESPACE));
            }
        }
        if (isNsSupported) {
            int len = reader.getNamespaceCount();
            for (int i3 = 0; i3 < len; ++i3) {
                element.addNamespaceDeclaration(Namespace.getNamespace(reader.getNamespacePrefix(i3), reader.getNamespaceURI(i3)));
            }
        }
        Element element2 = element;
        if (element2 == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(8);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/SafeStAXStreamBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/SafeStAXStreamBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processElementFragment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDocument";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processElementFragment";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

