/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CancellationKt;
import com.intellij.openapi.progress.CoroutineSuspenderElement;
import com.intellij.openapi.progress.CoroutineSuspenderElementKey;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.IndicatorRawProgressReporter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.ProgressReporterKt;
import com.intellij.openapi.progress.RawProgressReporter;
import com.intellij.openapi.progress.RawProgressReporterIndicator;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a%\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a!\u0010\n\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007\u00a2\u0006\u0002\u0010\u000b\u001a\u0011\u0010\f\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a)\u0010\u000e\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a%\u0010\u0012\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001aG\u0010\u0013\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0014\u001a\u00020\u00152'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016\u00a2\u0006\u0002\b\u001aH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a1\u0010\u001c\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007\u00a2\u0006\u0002\u0010\u001f\u001aG\u0010 \u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0014\u001a\u00020\u00152'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016\u00a2\u0006\u0002\b\u001aH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001aG\u0010 \u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010!\u001a\u00020\"2'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016\u00a2\u0006\u0002\b\u001aH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#\u001a=\u0010 \u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016\u00a2\u0006\u0002\b\u001a\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\u001a?\u0010%\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016\u00a2\u0006\u0002\b\u001aH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\u001aG\u0010&\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0014\u001a\u00020\u00152'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016\u00a2\u0006\u0002\b\u001aH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a?\u0010&\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0016\u00a2\u0006\u0002\b\u001aH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\u001a%\u0010'\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a\f\u0010(\u001a\u00020\u0015*\u00020\u0010H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "assertBackgroundThreadOrWriteAction", "", "blockingContext", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "blockingContextToIndicator", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkCancelled", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "contextToIndicator", "ctx", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "coroutineToIndicator", "indicatorRunBlockingCancellable", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "jobToIndicator", "job", "Lkotlinx/coroutines/Job;", "(Lkotlinx/coroutines/Job;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "runBlockingCancellable", "allowOrphan", "", "(ZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "runBlockingMaybeCancellable", "runSuspendingAction", "runUnderIndicator", "createIndicator", "intellij.platform.core"})
@ApiStatus.Experimental
public final class CoroutinesKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Object checkCancelled(@NotNull Continuation<? super Unit> $completion) {
        CoroutineContext ctx = $completion.getContext();
        JobKt.ensureActive(ctx);
        CoroutineSuspenderElement coroutineSuspenderElement = (CoroutineSuspenderElement)ctx.get((CoroutineContext.Key)CoroutineSuspenderElementKey.INSTANCE);
        if (coroutineSuspenderElement != null) {
            Object object = coroutineSuspenderElement.checkPaused($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final <T> T runBlockingCancellable(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CoroutinesKt.runBlockingCancellable(false, action2);
    }

    private static final <T> T runBlockingCancellable(boolean allowOrphan, Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action2) {
        ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
        if (indicator != null) {
            return CoroutinesKt.indicatorRunBlockingCancellable(indicator, action2);
        }
        CoroutinesKt.assertBackgroundThreadOrWriteAction();
        return CancellationKt.ensureCurrentJob(allowOrphan, (Function1)new Function1<Job, T>(action2){
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$action = $action;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T invoke(@NotNull Job currentJob) {
                T t;
                Intrinsics.checkNotNullParameter((Object)currentJob, (String)"currentJob");
                CoroutineContext context2 = ThreadContext.currentThreadContext().plus((CoroutineContext)currentJob).plus((CoroutineContext)new CoroutineName("job run blocking"));
                AutoCloseable autoCloseable = ThreadContext.replaceThreadContext((CoroutineContext)EmptyCoroutineContext.INSTANCE);
                Function2<CoroutineScope, Continuation<? super T>, Object> function2 = this.$action;
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    t = BuildersKt.runBlocking(context2, function2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return t;
            }
        });
    }

    @ApiStatus.Internal
    public static final <T> T runBlockingMaybeCancellable(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CoroutinesKt.runBlockingCancellable(true, action2);
    }

    @Deprecated(message="This method is public for compatibility. It is not supposed to be used outside of the platform. Use `runBlockingCancellable` instead.")
    @ApiStatus.Internal
    public static final <T> T indicatorRunBlockingCancellable(@NotNull ProgressIndicator indicator, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        CoroutinesKt.assertBackgroundThreadOrWriteAction();
        return CancellationKt.ensureCurrentJob(indicator, (Function1)new Function1<Job, T>(indicator, action2){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$indicator = $indicator;
                this.$action = $action;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T invoke(@NotNull Job currentJob) {
                T t;
                Intrinsics.checkNotNullParameter((Object)currentJob, (String)"currentJob");
                CoroutineContext context2 = ThreadContext.currentThreadContext().plus((CoroutineContext)currentJob).plus((CoroutineContext)new CoroutineName("indicator run blocking")).plus((CoroutineContext)ProgressReporterKt.asContextElement(new IndicatorRawProgressReporter(this.$indicator)));
                AutoCloseable autoCloseable = ThreadContext.replaceThreadContext((CoroutineContext)EmptyCoroutineContext.INSTANCE);
                Function2<CoroutineScope, Continuation<? super T>, Object> function2 = this.$action;
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    t = BuildersKt.runBlocking(context2, function2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return t;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <T> Object blockingContext(@NotNull Function0<? extends T> action2, @NotNull Continuation<? super T> $completion) {
        T t;
        CoroutineContext currentContext = $completion.getContext().minusKey((CoroutineContext.Key)ContinuationInterceptor.Key);
        AutoCloseable autoCloseable = ThreadContext.replaceThreadContext(currentContext);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            t = CancellationKt.withCurrentJob(JobKt.getJob(currentContext), action2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return t;
    }

    @ApiStatus.Internal
    @Nullable
    public static final <T> Object coroutineToIndicator(@NotNull Function0<? extends T> action2, @NotNull Continuation<? super T> $completion) {
        CoroutineContext ctx = $completion.getContext();
        return CoroutinesKt.contextToIndicator(ctx, action2);
    }

    @ApiStatus.Internal
    public static final <T> T blockingContextToIndicator(@NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        CoroutineContext ctx = ThreadContext.currentThreadContext();
        return CoroutinesKt.contextToIndicator(ctx, action2);
    }

    private static final <T> T contextToIndicator(CoroutineContext ctx, Function0<? extends T> action2) {
        Job job = JobKt.getJob(ctx);
        JobKt.ensureActive(job);
        ProgressIndicator indicator = CoroutinesKt.createIndicator(ctx);
        return CoroutinesKt.jobToIndicator(job, indicator, action2);
    }

    private static final ProgressIndicator createIndicator(CoroutineContext $this$createIndicator) {
        ModalityState modalityState = ModalityKt.contextModality($this$createIndicator);
        if (modalityState == null) {
            ModalityState modalityState2 = ModalityState.NON_MODAL;
            modalityState = modalityState2;
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"NON_MODAL");
        }
        ModalityState contextModality = modalityState;
        if (ProgressReporterKt.getProgressReporter($this$createIndicator) != null) {
            LOG.error(new IllegalStateException("Current context has `ProgressReporter`. Please switch to `RawProgressReporter` before switching to indicator. See 'Progress reporting' in `coroutineToIndicator` and/or `blockingContextToIndicator`.\nCurrent context: " + $this$createIndicator));
            return new EmptyProgressIndicator(contextModality);
        }
        RawProgressReporter reporter = ProgressReporterKt.getRawProgressReporter($this$createIndicator);
        return reporter == null ? (ProgressIndicator)new EmptyProgressIndicator(contextModality) : (ProgressIndicator)new RawProgressReporterIndicator(reporter, contextModality);
    }

    @ApiStatus.Internal
    public static final <T> T jobToIndicator(@NotNull Job job, @NotNull ProgressIndicator indicator, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        try {
            return (T)ProgressManager.getInstance().runProcess(() -> CoroutinesKt.jobToIndicator$lambda$1(job, indicator, action2), indicator);
        }
        catch (ProcessCanceledException e) {
            if (!indicator.isCanceled()) {
                throw e;
            }
            if (!job.isCancelled()) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            throw job.getCancellationException();
        }
    }

    private static final void assertBackgroundThreadOrWriteAction() {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() || application.isWriteAccessAllowed() || application.isUnitTestMode()) {
            return;
        }
        LOG.error(new IllegalStateException("This method is forbidden on EDT because it does not pump the event queue. Switch to a BGT, or use com.intellij.openapi.progress.TasksKt.runBlockingModal. "));
    }

    @Deprecated(message="Method was renamed. Don't use", replaceWith=@ReplaceWith(expression="indicatorRunBlockingCancellable(indicator, action)", imports={}), level=DeprecationLevel.ERROR)
    public static final <T> T runBlockingCancellable(@NotNull ProgressIndicator indicator, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CoroutinesKt.indicatorRunBlockingCancellable(indicator, action2);
    }

    @Deprecated(message="Method was renamed", replaceWith=@ReplaceWith(expression="runBlockingCancellable(action)", imports={}), level=DeprecationLevel.ERROR)
    @ApiStatus.ScheduledForRemoval
    public static final <T> T runSuspendingAction(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CoroutinesKt.runBlockingCancellable(action2);
    }

    @Deprecated(message="Method was renamed", replaceWith=@ReplaceWith(expression="runBlockingCancellable(indicator, action)", imports={}), level=DeprecationLevel.ERROR)
    @ApiStatus.ScheduledForRemoval
    public static final <T> T runSuspendingAction(@NotNull ProgressIndicator indicator, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return CoroutinesKt.indicatorRunBlockingCancellable(indicator, action2);
    }

    @Deprecated(message="Method was renamed", replaceWith=@ReplaceWith(expression="coroutineToIndicator(action)", imports={}), level=DeprecationLevel.ERROR)
    @Nullable
    public static final <T> Object runUnderIndicator(@NotNull Function0<? extends T> action2, @NotNull Continuation<? super T> $completion) {
        return CoroutinesKt.coroutineToIndicator(action2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object jobToIndicator$lambda$1(Job $job, ProgressIndicator $indicator, Function0 $action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        DisposableHandle completionHandle2 = Job.DefaultImpls.invokeOnCompletion$default($job, true, false, (Function1)new Function1<Throwable, Unit>($indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                if (it instanceof CancellationException) {
                    this.$indicator.cancel();
                }
            }
        }, 2, null);
        try {
            $indicator.checkCanceled();
            object = $action.invoke();
        }
        finally {
            completionHandle2.dispose();
        }
        return object;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.openapi.progress");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#com.intellij.openapi.progress\")");
        LOG = logger;
    }
}

