/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class ShortBasedStorage
implements DataStorage {
    protected short[] myData;

    public ShortBasedStorage() {
        this.myData = new short[64];
    }

    protected ShortBasedStorage(short[] data) {
        this.myData = data;
    }

    @Override
    public void setData(int segmentIndex, int data) {
        if (segmentIndex >= this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, SegmentArray.calcCapacity(this.myData.length, segmentIndex));
        }
        this.myData[segmentIndex] = (short)data;
    }

    @Override
    public void remove(int startIndex, int endIndex, int mySegmentCount) {
        if (endIndex < mySegmentCount) {
            System.arraycopy(this.myData, endIndex, this.myData, startIndex, mySegmentCount - endIndex);
        }
    }

    @Override
    public void replace(@NotNull DataStorage storage, int startOffset, int len) {
        if (storage == null) {
            ShortBasedStorage.$$$reportNull$$$0(0);
        }
        assert (storage instanceof ShortBasedStorage);
        System.arraycopy(((ShortBasedStorage)storage).myData, 0, this.myData, startOffset, len);
    }

    @Override
    public void insert(@NotNull DataStorage storageToInsert, int startIndex, int segmentCountToInsert, int segmentCount) {
        if (storageToInsert == null) {
            ShortBasedStorage.$$$reportNull$$$0(1);
        }
        assert (storageToInsert instanceof ShortBasedStorage);
        this.myData = ShortBasedStorage.insert(this.myData, ((ShortBasedStorage)storageToInsert).myData, startIndex, segmentCountToInsert, segmentCount);
    }

    @Override
    public int getData(int index2) {
        return this.myData[index2];
    }

    @Override
    public int packData(@NotNull IElementType tokenType, int state, boolean isRestartableState) {
        if (tokenType == null) {
            ShortBasedStorage.$$$reportNull$$$0(2);
        }
        short idx = tokenType.getIndex();
        return isRestartableState ? idx : -idx;
    }

    @Override
    public int unpackStateFromData(int data) {
        throw new UnsupportedOperationException("Unable to unpack state, state is not stored in ShortBasedStorage");
    }

    @Override
    @NotNull
    public IElementType unpackTokenFromData(int data) {
        IElementType iElementType = IElementType.find((short)Math.abs(data));
        if (iElementType == null) {
            ShortBasedStorage.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @Override
    @NotNull
    public DataStorage copy() {
        return new ShortBasedStorage(this.myData);
    }

    @Override
    @NotNull
    public DataStorage createStorage() {
        return new ShortBasedStorage();
    }

    protected static short @NotNull [] insert(short @NotNull [] array2, short @NotNull [] insertArray, int startIndex, int insertLength, int mySegmentCount) {
        if (array2 == null) {
            ShortBasedStorage.$$$reportNull$$$0(4);
        }
        if (insertArray == null) {
            ShortBasedStorage.$$$reportNull$$$0(5);
        }
        short[] newArray = ShortBasedStorage.reallocateArray(array2, mySegmentCount + insertLength);
        if (startIndex < mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            ShortBasedStorage.$$$reportNull$$$0(6);
        }
        return newArray;
    }

    protected static short @NotNull [] reallocateArray(short @NotNull [] array2, int index2) {
        if (array2 == null) {
            ShortBasedStorage.$$$reportNull$$$0(7);
        }
        if (index2 < array2.length) {
            if (array2 == null) {
                ShortBasedStorage.$$$reportNull$$$0(8);
            }
            return array2;
        }
        short[] sArray = ArrayUtil.realloc(array2, SegmentArray.calcCapacity(array2.length, index2));
        if (sArray == null) {
            ShortBasedStorage.$$$reportNull$$$0(9);
        }
        return sArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageToInsert";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/ShortBasedStorage";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/ShortBasedStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackTokenFromData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "packData";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

