/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.FileParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JShellElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JShellParser
extends JavaParser {
    public static final JShellParser INSTANCE = new JShellParser();
    private static final TokenSet TOP_LEVEL_DECLARATIONS = TokenSet.create(JavaElementType.FIELD, JavaElementType.METHOD, JavaElementType.CLASS);
    private static final Predicate<IElementType> IMPORT_PARSED_CONDITION = tokenType -> JavaElementType.IMPORT_STATEMENT.equals(tokenType);
    private static final Predicate<IElementType> EXPRESSION_PARSED_CONDITION = type -> type != JavaElementType.REFERENCE_EXPRESSION;
    private static final Predicate<IElementType> STATEMENTS_PARSED_CONDITION = tokenType -> !JavaElementType.DECLARATION_STATEMENT.equals(tokenType) && !JavaElementType.EXPRESSION_STATEMENT.equals(tokenType);
    private static final Predicate<IElementType> DECLARATION_PARSED_CONDITION = tokenType -> TOP_LEVEL_DECLARATIONS.contains((IElementType)tokenType);
    private final FileParser myJShellFileParser = new FileParser(this){
        private final TokenSet IMPORT_PARSING_STOP_LIST;
        {
            this.IMPORT_PARSING_STOP_LIST = TokenSet.orSet(IMPORT_LIST_STOPPER_SET, TokenSet.orSet(ElementType.MODIFIER_BIT_SET, ElementType.JAVA_COMMENT_BIT_SET, ElementType.EXPRESSION_BIT_SET, ElementType.JAVA_STATEMENT_BIT_SET, ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JShellElementType.ROOT_CLASS, JavaTokenType.IDENTIFIER)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(@NotNull PsiBuilder builder) {
            if (builder == null) {
                1.$$$reportNull$$$0(0);
            }
            this.parseImportList(builder, b -> this.IMPORT_PARSING_STOP_LIST.contains(b.getTokenType()));
            PsiBuilder.Marker rootClass = builder.mark();
            try {
                while (!builder.eof()) {
                    PsiBuilder.Marker wrapper = builder.mark();
                    IElementType wrapperType = null;
                    PsiBuilder.Marker marker = this.parseImportStatement(builder);
                    if (JShellParser.isParsed(marker, builder, IMPORT_PARSED_CONDITION)) {
                        wrapperType = JShellElementType.IMPORT_HOLDER;
                    } else {
                        JShellParser.revert(marker);
                        marker = JShellParser.this.getExpressionParser().parse(builder);
                        if (JShellParser.isParsed(marker, builder, EXPRESSION_PARSED_CONDITION) && !((PsiBuilderImpl)builder).hasErrorsAfter(marker)) {
                            wrapperType = JShellElementType.STATEMENTS_HOLDER;
                        } else {
                            JShellParser.revert(marker);
                            marker = JShellParser.this.getStatementParser().parseStatement(builder);
                            if (JShellParser.isParsed(marker, builder, STATEMENTS_PARSED_CONDITION)) {
                                wrapperType = JShellElementType.STATEMENTS_HOLDER;
                            } else {
                                JShellParser.revert(marker);
                                marker = JShellParser.this.getDeclarationParser().parse(builder, DeclarationParser.Context.CLASS);
                                if (JShellParser.isParsed(marker, builder, DECLARATION_PARSED_CONDITION)) {
                                    wrapper.drop();
                                    wrapper = null;
                                } else {
                                    JShellParser.revert(marker);
                                    marker = JShellParser.this.getExpressionParser().parse(builder);
                                    IElementType iElementType = wrapperType = marker != null ? JShellElementType.STATEMENTS_HOLDER : null;
                                }
                            }
                        }
                    }
                    if (marker == null) {
                        wrapper.drop();
                        break;
                    }
                    if (wrapper == null) continue;
                    wrapper.done(wrapperType);
                }
                if (!builder.eof()) {
                    builder.mark().error(JavaPsiBundle.message("unexpected.token", new Object[0]));
                    while (!builder.eof()) {
                        builder.advanceLexer();
                    }
                }
            }
            finally {
                rootClass.done(JShellElementType.ROOT_CLASS);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/java/parser/JShellParser$1", "parse"));
        }
    };

    private static boolean isParsed(@Nullable PsiBuilder.Marker parsedMarker, PsiBuilder builder, Predicate<? super IElementType> cond) {
        if (parsedMarker == null) {
            return false;
        }
        LighterASTNode lastDone = builder.getLatestDoneMarker();
        if (lastDone == null) {
            return false;
        }
        return cond.test(lastDone.getTokenType());
    }

    private static void revert(PsiBuilder.Marker parsedMarker) {
        if (parsedMarker != null) {
            parsedMarker.rollbackTo();
        }
    }

    @Override
    @NotNull
    public FileParser getFileParser() {
        FileParser fileParser = this.myJShellFileParser;
        if (fileParser == null) {
            JShellParser.$$$reportNull$$$0(0);
        }
        return fileParser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/JShellParser", "getFileParser"));
    }
}

