/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
    private static final Key<Pair<SoftReference<Application>, Set<MetaLanguage>>> MATCHING_LANGUAGES = Key.create("language.matching");

    private LanguageUtil() {
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(0);
        }
        return LanguageUtil.getLanguageForPsi(project, file2, null);
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file2, @Nullable FileType fileType) {
        Language fileLanguage;
        Language explicit;
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            return null;
        }
        Language language = explicit = file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getLanguage() : null;
        Language language2 = explicit != null ? explicit : (fileLanguage = LanguageUtil.getFileTypeLanguage(fileType != null ? fileType : file2.getFileType()));
        if (fileLanguage == null) {
            return null;
        }
        for (LanguageSubstitutor substitutor : LanguageSubstitutors.getInstance().forKey(Language.ANY)) {
            Language language3 = substitutor.getLanguage(file2, project);
            if (language3 == null || language3 == Language.ANY) continue;
            fileLanguage = language3;
            break;
        }
        return LanguageSubstitutors.getInstance().substituteLanguage(fileLanguage, file2, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        Language l = file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getLanguage() : null;
        return l != null ? l : LanguageUtil.getFileTypeLanguage(file2.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@NotNull FileType fileType) {
        if (fileType == null) {
            LanguageUtil.$$$reportNull$$$0(2);
        }
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Nullable
    public static FileType getLanguageFileType(@Nullable Language language) {
        return language == null ? null : language.getAssociatedFileType();
    }

    @NotNull
    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(@NotNull ASTNode left, @NotNull ASTNode right, @NotNull Lexer lexer) {
        if (left == null) {
            LanguageUtil.$$$reportNull$$$0(3);
        }
        if (right == null) {
            LanguageUtil.$$$reportNull$$$0(4);
        }
        if (lexer == null) {
            LanguageUtil.$$$reportNull$$$0(5);
        }
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                LanguageUtil.$$$reportNull$$$0(6);
            }
            return spaceRequirements;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                LanguageUtil.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                LanguageUtil.$$$reportNull$$$0(8);
            }
            return spaceRequirements;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                LanguageUtil.$$$reportNull$$$0(9);
            }
            return spaceRequirements;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            LanguageUtil.$$$reportNull$$$0(10);
        }
        return spaceRequirements;
    }

    @NotNull
    public static Set<Language> getAllDerivedLanguages(@NotNull Language base) {
        if (base == null) {
            LanguageUtil.$$$reportNull$$$0(11);
        }
        HashSet<Language> result2 = new HashSet<Language>();
        LanguageUtil.getAllDerivedLanguages(base, result2);
        HashSet<Language> hashSet = result2;
        if (hashSet == null) {
            LanguageUtil.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    private static void getAllDerivedLanguages(@NotNull Language base, @NotNull Set<? super Language> result2) {
        if (base == null) {
            LanguageUtil.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            LanguageUtil.$$$reportNull$$$0(14);
        }
        result2.add(base);
        for (Language dialect : base.getDialects()) {
            LanguageUtil.getAllDerivedLanguages(dialect, result2);
        }
    }

    public static boolean isInTemplateLanguageFile(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            LanguageUtil.$$$reportNull$$$0(15);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(16);
        }
        if (language == Language.ANY) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    @NotNull
    public static List<Language> getInjectableLanguages() {
        return LanguageUtil.getLanguages(lang -> LanguageUtil.isInjectableLanguage(lang));
    }

    public static boolean isFileLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(17);
        }
        if (language instanceof DependentLanguage || language instanceof InjectableLanguage) {
            return false;
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            return false;
        }
        LanguageFileType type = language.getAssociatedFileType();
        return type != null && !StringUtil.isEmpty(type.getDefaultExtension());
    }

    @NotNull
    public static List<Language> getFileLanguages() {
        return LanguageUtil.getLanguages(lang -> LanguageUtil.isFileLanguage(lang));
    }

    @NotNull
    public static List<Language> getLanguages(@NotNull Predicate<? super Language> filter2) {
        if (filter2 == null) {
            LanguageUtil.$$$reportNull$$$0(18);
        }
        LanguageParserDefinitions.INSTANCE.ensureValuesLoaded();
        ArrayList<Language> result2 = new ArrayList<Language>();
        for (Language language : Language.getRegisteredLanguages()) {
            if (!filter2.test(language)) continue;
            result2.add(language);
        }
        result2.sort(LANGUAGE_COMPARATOR);
        ArrayList<Language> arrayList = result2;
        if (arrayList == null) {
            LanguageUtil.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        Language language;
        PsiFile containingFile;
        FileViewProvider provider;
        Set<Language> languages;
        if (element == null) {
            LanguageUtil.$$$reportNull$$$0(20);
        }
        if ((languages = (provider = (containingFile = element.getContainingFile()).getViewProvider()).getLanguages()).size() > 1 && languages.contains(language = containingFile.getLanguage())) {
            Language language2 = language;
            if (language2 == null) {
                LanguageUtil.$$$reportNull$$$0(21);
            }
            return language2;
        }
        Language language3 = provider.getBaseLanguage();
        if (language3 == null) {
            LanguageUtil.$$$reportNull$$$0(22);
        }
        return language3;
    }

    @NotNull
    static Collection<MetaLanguage> matchingMetaLanguages(@NotNull Language language) {
        Set<MetaLanguage> result2;
        Pair<SoftReference<Application>, Set<MetaLanguage>> cached;
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(23);
        }
        if ((cached = language.getUserData(MATCHING_LANGUAGES)) != null && ((SoftReference)cached.first).get() == ApplicationManager.getApplication()) {
            Collection collection = (Collection)cached.second;
            if (collection == null) {
                LanguageUtil.$$$reportNull$$$0(24);
            }
            return collection;
        }
        if (!ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(MetaLanguage.EP_NAME)) {
            List<MetaLanguage> list = Collections.emptyList();
            if (list == null) {
                LanguageUtil.$$$reportNull$$$0(25);
            }
            return list;
        }
        if (language instanceof MetaLanguage) {
            result2 = Collections.emptySet();
        } else {
            result2 = new HashSet();
            MetaLanguage.EP_NAME.forEachExtensionSafe(metaLanguage -> {
                if (metaLanguage.matchesLanguage(language)) {
                    result2.add((MetaLanguage)metaLanguage);
                }
            });
        }
        Pair toCache = Pair.create(new SoftReference<Application>(ApplicationManager.getApplication()), result2);
        language.putUserData(MATCHING_LANGUAGES, toCache);
        Set<MetaLanguage> set = result2;
        if (set == null) {
            LanguageUtil.$$$reportNull$$$0(26);
        }
        return set;
    }

    static void clearMatchingMetaLanguages(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(27);
        }
        language.putUserData(MATCHING_LANGUAGES, null);
    }

    @NotNull
    public static JBIterable<Language> getBaseLanguages(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(28);
        }
        JBIterable<Language> jBIterable = JBIterable.generate(language, Language::getBaseLanguage);
        if (jBIterable == null) {
            LanguageUtil.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/LanguageUtil";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 17: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/LanguageUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "canStickTokensTogetherByLexer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDerivedLanguages";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootLanguage";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingMetaLanguages";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForPsi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canStickTokensTogetherByLexer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllDerivedLanguages";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInTemplateLanguageFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInjectableLanguage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFileLanguage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLanguages";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRootLanguage";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "matchingMetaLanguages";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "clearMatchingMetaLanguages";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBaseLanguages";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

