/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OperationParserHelper {
    private static boolean parsePostfixOperation(@NotNull BinaryOperationParser parser) {
        PsiBuilder.Marker tempMarker;
        if (parser == null) {
            OperationParserHelper.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker lastMarker = tempMarker = parser.mark();
        boolean result2 = OperationParserHelper.parsePrefixOperation(parser);
        boolean tempMarkerDeleted = false;
        while (parser.getPostfixOperators().contains(parser.getTokenType()) && !parser.getWhitespaceTokenSet().contains(parser.rawLookup(-1)) && !parser.isNewLine()) {
            PsiBuilder.Marker operationMarker = lastMarker.precede();
            if (!tempMarkerDeleted) {
                tempMarker.drop();
                tempMarkerDeleted = true;
            }
            lastMarker = operationMarker;
            parser.advance();
            parser.done(operationMarker, parser.getPostfixExpressionElementType());
            result2 = true;
        }
        if (!tempMarkerDeleted) {
            tempMarker.drop();
        }
        return result2;
    }

    private static boolean parsePrefixOperation(@NotNull BinaryOperationParser parser) {
        if (parser == null) {
            OperationParserHelper.$$$reportNull$$$0(1);
        }
        int prefixCount = 0;
        while (parser.getPrefixOperators().contains(parser.lookAhead(prefixCount))) {
            ++prefixCount;
        }
        PsiBuilder.Marker[] prefixMarkers = new PsiBuilder.Marker[prefixCount];
        IElementType[] elementTypes = new IElementType[prefixCount];
        for (int i2 = 0; i2 < prefixCount; ++i2) {
            prefixMarkers[i2] = parser.mark();
            elementTypes[i2] = parser.getPrefixExpressionElementType();
            parser.advance();
        }
        boolean result2 = parser.parseSimpleExpression() || prefixCount > 0;
        for (int i3 = prefixCount - 1; i3 >= 0; --i3) {
            parser.done(prefixMarkers[i3], elementTypes[i3]);
        }
        return result2;
    }

    public static boolean callParsingBinaryOperation(@NotNull BinaryOperationParser parser, int level) {
        if (parser == null) {
            OperationParserHelper.$$$reportNull$$$0(2);
        }
        if (level < 0) {
            return OperationParserHelper.parsePostfixOperation(parser);
        }
        return OperationParserHelper.parseBinaryOperation(parser, level);
    }

    private static boolean isBinaryOperator(@NotNull BinaryOperationParser parser, int level) {
        if (parser == null) {
            OperationParserHelper.$$$reportNull$$$0(3);
        }
        if (parser instanceof CustomBinaryOperationParser) {
            return ((CustomBinaryOperationParser)((Object)parser)).isBinaryOperator(level);
        }
        IElementType tokenType = parser.getTokenType();
        return parser.getOperatorsByPriority()[level].contains(tokenType);
    }

    private static void parseBinaryOperator(@NotNull BinaryOperationParser parser) {
        if (parser == null) {
            OperationParserHelper.$$$reportNull$$$0(4);
        }
        if (parser instanceof CustomBinaryOperationParser) {
            ((CustomBinaryOperationParser)((Object)parser)).parseBinaryOperator();
        } else {
            parser.advance();
        }
    }

    private static boolean parseBinaryOperation(@NotNull BinaryOperationParser parser, int level) {
        PsiBuilder.Marker tempMarker;
        if (parser == null) {
            OperationParserHelper.$$$reportNull$$$0(5);
        }
        PsiBuilder.Marker lastMarker = tempMarker = parser.mark();
        boolean result2 = OperationParserHelper.callParsingBinaryOperation(parser, level - 1);
        boolean tempMarkerDeleted = false;
        while (OperationParserHelper.isBinaryOperator(parser, level) && !parser.isNewLine()) {
            PsiBuilder.Marker operationMarker = lastMarker.precede();
            if (!tempMarkerDeleted) {
                tempMarker.drop();
                tempMarkerDeleted = true;
            }
            lastMarker = operationMarker;
            OperationParserHelper.parseBinaryOperator(parser);
            OperationParserHelper.callParsingBinaryOperation(parser, level - 1);
            parser.done(operationMarker, parser.getOperationElementTypes()[level]);
            result2 = true;
        }
        if (!tempMarkerDeleted) {
            tempMarker.drop();
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "parser";
        objectArray2[1] = "com/intellij/indentation/OperationParserHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parsePostfixOperation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parsePrefixOperation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "callParsingBinaryOperation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isBinaryOperator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseBinaryOperator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseBinaryOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface BinaryOperationParser {
        public IElementType getTokenType();

        public boolean isNewLine();

        public void advance();

        public IElementType rawLookup(int var1);

        public IElementType lookAhead(int var1);

        public PsiBuilder.Marker mark();

        public void done(PsiBuilder.Marker var1, IElementType var2);

        public boolean parseSimpleExpression();

        public TokenSet getWhitespaceTokenSet();

        public TokenSet getPrefixOperators();

        public TokenSet getPostfixOperators();

        public TokenSet @NotNull [] getOperatorsByPriority();

        @Nullable
        public IElementType getPostfixExpressionElementType();

        @Nullable
        public IElementType getPrefixExpressionElementType();

        public IElementType @NotNull [] getOperationElementTypes();
    }

    public static interface CustomBinaryOperationParser {
        public boolean isBinaryOperator(int var1);

        public void parseBinaryOperator();
    }
}

