/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ByLineRt {
    @NotNull
    public static FairDiffIterable compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(0);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            ByLineRt.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ByLineRt.$$$reportNull$$$0(3);
        }
        indicator.checkCanceled();
        return ByLineRt.doCompare(ByLineRt.getLines(lines1, policy), ByLineRt.getLines(lines2, policy), policy, indicator);
    }

    @NotNull
    public static List<MergeRange> compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(4);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(5);
        }
        if (lines3 == null) {
            ByLineRt.$$$reportNull$$$0(6);
        }
        if (policy == null) {
            ByLineRt.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            ByLineRt.$$$reportNull$$$0(8);
        }
        indicator.checkCanceled();
        return ByLineRt.doCompare(ByLineRt.getLines(lines1, policy), ByLineRt.getLines(lines2, policy), ByLineRt.getLines(lines3, policy), policy, indicator, false);
    }

    @NotNull
    public static List<MergeRange> merge(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(9);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(10);
        }
        if (lines3 == null) {
            ByLineRt.$$$reportNull$$$0(11);
        }
        if (policy == null) {
            ByLineRt.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            ByLineRt.$$$reportNull$$$0(13);
        }
        indicator.checkCanceled();
        return ByLineRt.doCompare(ByLineRt.getLines(lines1, policy), ByLineRt.getLines(lines2, policy), ByLineRt.getLines(lines3, policy), policy, indicator, true);
    }

    @NotNull
    static FairDiffIterable doCompare(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(14);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(15);
        }
        if (policy == null) {
            ByLineRt.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            ByLineRt.$$$reportNull$$$0(17);
        }
        indicator.checkCanceled();
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            FairDiffIterable changes = ByLineRt.compareSmart(lines1, lines2, indicator);
            changes = ByLineRt.optimizeLineChunks(lines1, lines2, changes, indicator);
            return ByLineRt.expandRanges(lines1, lines2, changes);
        }
        List<Line> iwLines1 = ByLineRt.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLineRt.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges = ByLineRt.compareSmart(iwLines1, iwLines2, indicator);
        iwChanges = ByLineRt.optimizeLineChunks(lines1, lines2, iwChanges, indicator);
        return ByLineRt.correctChangesSecondStep(lines1, lines2, iwChanges);
    }

    @NotNull
    static List<MergeRange> doCompare(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull List<? extends Line> lines3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator, boolean keepIgnoredChanges) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(18);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(19);
        }
        if (lines3 == null) {
            ByLineRt.$$$reportNull$$$0(20);
        }
        if (policy == null) {
            ByLineRt.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            ByLineRt.$$$reportNull$$$0(22);
        }
        indicator.checkCanceled();
        List<Line> iwLines1 = ByLineRt.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLineRt.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines3 = ByLineRt.convertMode(lines3, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges1 = ByLineRt.compareSmart(iwLines2, iwLines1, indicator);
        iwChanges1 = ByLineRt.optimizeLineChunks(lines2, lines1, iwChanges1, indicator);
        FairDiffIterable iterable1 = ByLineRt.correctChangesSecondStep(lines2, lines1, iwChanges1);
        FairDiffIterable iwChanges2 = ByLineRt.compareSmart(iwLines2, iwLines3, indicator);
        iwChanges2 = ByLineRt.optimizeLineChunks(lines2, lines3, iwChanges2, indicator);
        FairDiffIterable iterable2 = ByLineRt.correctChangesSecondStep(lines2, lines3, iwChanges2);
        if (keepIgnoredChanges && policy != ComparisonPolicy.DEFAULT) {
            List<MergeRange> list = ComparisonMergeUtil.buildMerge(iterable1, iterable2, (index1, index2, index3) -> ByLineRt.equalsDefaultPolicy(lines1, lines2, lines3, index1, index2, index3), indicator);
            if (list == null) {
                ByLineRt.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<MergeRange> list = ComparisonMergeUtil.buildSimple(iterable1, iterable2, indicator);
        if (list == null) {
            ByLineRt.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static boolean equalsDefaultPolicy(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull List<? extends Line> lines3, int index1, int index2, int index3) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(25);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(26);
        }
        if (lines3 == null) {
            ByLineRt.$$$reportNull$$$0(27);
        }
        CharSequence content1 = lines1.get(index1).getContent();
        CharSequence content2 = lines2.get(index2).getContent();
        CharSequence content3 = lines3.get(index3).getContent();
        return ComparisonUtil.isEquals(content2, content1, ComparisonPolicy.DEFAULT) && ComparisonUtil.isEquals(content2, content3, ComparisonPolicy.DEFAULT);
    }

    @NotNull
    private static FairDiffIterable correctChangesSecondStep(final @NotNull List<? extends Line> lines1, final @NotNull List<? extends Line> lines2, final @NotNull FairDiffIterable changes) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(28);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(29);
        }
        if (changes == null) {
            ByLineRt.$$$reportNull$$$0(30);
        }
        final DiffIterableUtil.ExpandChangeBuilder builder = new DiffIterableUtil.ExpandChangeBuilder(lines1, lines2);
        new Object(){
            private CharSequence sample = null;
            private int last1 = 0;
            private int last2 = 0;

            public void run() {
                for (Range range : changes.iterateUnchanged()) {
                    int count2 = range.end1 - range.start1;
                    for (int i2 = 0; i2 < count2; ++i2) {
                        int index1 = range.start1 + i2;
                        int index2 = range.start2 + i2;
                        Line line1 = (Line)lines1.get(index1);
                        Line line2 = (Line)lines2.get(index2);
                        if (ComparisonUtil.isEquals(this.sample, line1.getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                        if (line1.equals(line2)) {
                            this.flush(index1, index2);
                            builder.markEqual(index1, index2);
                            continue;
                        }
                        this.flush(index1, index2);
                        this.sample = line1.getContent();
                    }
                }
                this.flush(changes.getLength1(), changes.getLength2());
            }

            private void flush(int line1, int line2) {
                int i2;
                if (this.sample == null) {
                    return;
                }
                int start1 = Math.max(this.last1, builder.getIndex1());
                int start2 = Math.max(this.last2, builder.getIndex2());
                IntArrayList subLines1 = new IntArrayList();
                IntArrayList subLines2 = new IntArrayList();
                for (i2 = start1; i2 < line1; ++i2) {
                    if (!ComparisonUtil.isEquals(this.sample, ((Line)lines1.get(i2)).getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                    subLines1.add(i2);
                    this.last1 = i2 + 1;
                }
                for (i2 = start2; i2 < line2; ++i2) {
                    if (!ComparisonUtil.isEquals(this.sample, ((Line)lines2.get(i2)).getContent(), ComparisonPolicy.IGNORE_WHITESPACES)) continue;
                    subLines2.add(i2);
                    this.last2 = i2 + 1;
                }
                assert (subLines1.size() > 0 && subLines2.size() > 0);
                this.alignExactMatching(subLines1, subLines2);
                this.sample = null;
            }

            private void alignExactMatching(IntList subLines1, IntList subLines2) {
                boolean skipAligning;
                int n = Math.max(subLines1.size(), subLines2.size());
                boolean bl = skipAligning = n > 10 || subLines1.size() == subLines2.size();
                if (skipAligning) {
                    int count2 = Math.min(subLines1.size(), subLines2.size());
                    for (int i2 = 0; i2 < count2; ++i2) {
                        int index1 = subLines1.getInt(i2);
                        int index2 = subLines2.getInt(i2);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                    return;
                }
                if (subLines1.size() < subLines2.size()) {
                    int[] matching = ByLineRt.getBestMatchingAlignment(subLines1, subLines2, lines1, lines2);
                    for (int i3 = 0; i3 < subLines1.size(); ++i3) {
                        int index1 = subLines1.getInt(i3);
                        int index2 = subLines2.getInt(matching[i3]);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                } else {
                    int[] matching = ByLineRt.getBestMatchingAlignment(subLines2, subLines1, lines2, lines1);
                    for (int i4 = 0; i4 < subLines2.size(); ++i4) {
                        int index1 = subLines1.getInt(matching[i4]);
                        int index2 = subLines2.getInt(i4);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                }
            }
        }.run();
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder.finish());
        if (fairDiffIterable == null) {
            ByLineRt.$$$reportNull$$$0(31);
        }
        return fairDiffIterable;
    }

    private static int @NotNull [] getBestMatchingAlignment(final @NotNull IntList subLines1, final @NotNull IntList subLines2, final @NotNull List<? extends Line> lines1, final @NotNull List<? extends Line> lines2) {
        if (subLines1 == null) {
            ByLineRt.$$$reportNull$$$0(32);
        }
        if (subLines2 == null) {
            ByLineRt.$$$reportNull$$$0(33);
        }
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(34);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(35);
        }
        assert (subLines1.size() < subLines2.size());
        final int size = subLines1.size();
        final int[] comb = new int[size];
        final int[] best = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            best[i2] = i2;
        }
        new Object(){
            int bestWeight = 0;

            public void run() {
                this.combinations(0, subLines2.size() - 1, 0);
            }

            private void combinations(int start, int n, int k) {
                if (k == size) {
                    this.processCombination();
                    return;
                }
                for (int i2 = start; i2 <= n; ++i2) {
                    comb[k] = i2;
                    this.combinations(i2 + 1, n, k + 1);
                }
            }

            private void processCombination() {
                int weight = 0;
                for (int i2 = 0; i2 < size; ++i2) {
                    int index1 = subLines1.getInt(i2);
                    int index2 = subLines2.getInt(comb[i2]);
                    if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                    ++weight;
                }
                if (weight > this.bestWeight) {
                    this.bestWeight = weight;
                    System.arraycopy(comb, 0, best, 0, comb.length);
                }
            }
        }.run();
        if (best == null) {
            ByLineRt.$$$reportNull$$$0(36);
        }
        return best;
    }

    @NotNull
    private static FairDiffIterable optimizeLineChunks(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull FairDiffIterable iterable, @NotNull CancellationChecker indicator) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(37);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(38);
        }
        if (iterable == null) {
            ByLineRt.$$$reportNull$$$0(39);
        }
        if (indicator == null) {
            ByLineRt.$$$reportNull$$$0(40);
        }
        FairDiffIterable fairDiffIterable = new ChunkOptimizer.LineChunkOptimizer(lines1, lines2, iterable, indicator).build();
        if (fairDiffIterable == null) {
            ByLineRt.$$$reportNull$$$0(41);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable compareSmart(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull CancellationChecker indicator) {
        int threshold;
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(42);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(43);
        }
        if (indicator == null) {
            ByLineRt.$$$reportNull$$$0(44);
        }
        if ((threshold = ComparisonUtil.getUnimportantLineCharCount()) == 0) {
            FairDiffIterable fairDiffIterable = DiffIterableUtil.diff(lines1, lines2, indicator);
            if (fairDiffIterable == null) {
                ByLineRt.$$$reportNull$$$0(45);
            }
            return fairDiffIterable;
        }
        Pair<List<Line>, IntList> bigLines1 = ByLineRt.getBigLines(lines1, threshold);
        Pair<List<Line>, IntList> bigLines2 = ByLineRt.getBigLines(lines2, threshold);
        FairDiffIterable changes = DiffIterableUtil.diff((List)bigLines1.first, (List)bigLines2.first, indicator);
        FairDiffIterable fairDiffIterable = new ChangeCorrector.SmartLineChangeCorrector((IntList)bigLines1.second, (IntList)bigLines2.second, lines1, lines2, changes, indicator).build();
        if (fairDiffIterable == null) {
            ByLineRt.$$$reportNull$$$0(46);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static Pair<List<Line>, IntList> getBigLines(@NotNull List<? extends Line> lines, int threshold) {
        if (lines == null) {
            ByLineRt.$$$reportNull$$$0(47);
        }
        ArrayList<Line> bigLines = new ArrayList<Line>(lines.size());
        IntArrayList indexes = new IntArrayList(lines.size());
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            Line line = lines.get(i2);
            if (line.getNonSpaceChars() <= threshold) continue;
            bigLines.add(line);
            indexes.add(i2);
        }
        Pair<List<Line>, IntList> pair = Pair.create(bigLines, indexes);
        if (pair == null) {
            ByLineRt.$$$reportNull$$$0(48);
        }
        return pair;
    }

    @NotNull
    private static FairDiffIterable expandRanges(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull FairDiffIterable iterable) {
        if (lines1 == null) {
            ByLineRt.$$$reportNull$$$0(49);
        }
        if (lines2 == null) {
            ByLineRt.$$$reportNull$$$0(50);
        }
        if (iterable == null) {
            ByLineRt.$$$reportNull$$$0(51);
        }
        ArrayList<Range> changes = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range expanded = TrimUtil.expand(lines1, lines2, ch.start1, ch.start2, ch.end1, ch.end2);
            if (expanded.isEmpty()) continue;
            changes.add(expanded);
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(DiffIterableUtil.create(changes, lines1.size(), lines2.size()));
        if (fairDiffIterable == null) {
            ByLineRt.$$$reportNull$$$0(52);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static List<Line> getLines(@NotNull List<? extends CharSequence> text2, @NotNull ComparisonPolicy policy) {
        if (text2 == null) {
            ByLineRt.$$$reportNull$$$0(53);
        }
        if (policy == null) {
            ByLineRt.$$$reportNull$$$0(54);
        }
        List<Line> list = text2.stream().map(line -> new Line((CharSequence)line, policy)).collect(Collectors.toList());
        if (list == null) {
            ByLineRt.$$$reportNull$$$0(55);
        }
        return list;
    }

    @NotNull
    private static List<Line> convertMode(@NotNull List<? extends Line> original, @NotNull ComparisonPolicy policy) {
        if (original == null) {
            ByLineRt.$$$reportNull$$$0(56);
        }
        if (policy == null) {
            ByLineRt.$$$reportNull$$$0(57);
        }
        ArrayList<Line> result2 = new ArrayList<Line>(original.size());
        for (Line line : original) {
            Line newLine = line.myPolicy != policy ? new Line(line.getContent(), policy) : line;
            result2.add(newLine);
        }
        ArrayList<Line> arrayList = result2;
        if (arrayList == null) {
            ByLineRt.$$$reportNull$$$0(58);
        }
        return arrayList;
    }

    @NotNull
    public static List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<? extends MergeRange> conflicts) {
        if (conflicts == null) {
            ByLineRt.$$$reportNull$$$0(59);
        }
        List<MergeLineFragment> list = conflicts.stream().map(ch -> new MergeLineFragmentImpl((MergeRange)ch)).collect(Collectors.toList());
        if (list == null) {
            ByLineRt.$$$reportNull$$$0(60);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 24: 
            case 31: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 58: 
            case 60: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 24: 
            case 31: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 58: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines1";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 15: 
            case 19: 
            case 26: 
            case 29: 
            case 35: 
            case 38: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines2";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 16: 
            case 21: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 17: 
            case 22: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 11: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines3";
                break;
            }
            case 23: 
            case 24: 
            case 31: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ByLineRt";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subLines1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subLines2";
                break;
            }
            case 39: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ByLineRt";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompare";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "correctChangesSecondStep";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestMatchingAlignment";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeLineChunks";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "compareSmart";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigLines";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "expandRanges";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMode";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoMergeLineFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doCompare";
                break;
            }
            case 23: 
            case 24: 
            case 31: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 58: 
            case 60: {
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "equalsDefaultPolicy";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "correctChangesSecondStep";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getBestMatchingAlignment";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "optimizeLineChunks";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "compareSmart";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBigLines";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "expandRanges";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getLines";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "convertMode";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoMergeLineFragments";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 23: 
            case 24: 
            case 31: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 58: 
            case 60: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class Line {
        @NotNull
        private final CharSequence myText;
        @NotNull
        private final ComparisonPolicy myPolicy;
        private final int myHash;
        private final int myNonSpaceChars;

        Line(@NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
            if (text2 == null) {
                Line.$$$reportNull$$$0(0);
            }
            if (policy == null) {
                Line.$$$reportNull$$$0(1);
            }
            this.myText = text2;
            this.myPolicy = policy;
            this.myHash = ComparisonUtil.hashCode(text2, policy);
            this.myNonSpaceChars = Line.countNonSpaceChars(text2);
        }

        @NotNull
        public CharSequence getContent() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                Line.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        public int getNonSpaceChars() {
            return this.myNonSpaceChars;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            assert (this.myPolicy == line.myPolicy);
            if (this.hashCode() != line.hashCode()) {
                return false;
            }
            return ComparisonUtil.isEquals(this.getContent(), line.getContent(), this.myPolicy);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static int countNonSpaceChars(@NotNull CharSequence text2) {
            if (text2 == null) {
                Line.$$$reportNull$$$0(3);
            }
            int nonSpace = 0;
            int len = text2.length();
            for (int offset = 0; offset < len; ++offset) {
                char c = text2.charAt(offset);
                if (Strings.isWhiteSpace(c)) continue;
                ++nonSpace;
            }
            return nonSpace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ByLineRt$Line";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ByLineRt$Line";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "countNonSpaceChars";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

