/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.unsafe;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.unsafe.UnsafeUtil;
import java.io.InputStream;

public class UnsafeInput
extends Input {
    public UnsafeInput() {
    }

    public UnsafeInput(int bufferSize) {
        super(bufferSize);
    }

    public UnsafeInput(byte[] buffer) {
        super(buffer);
    }

    public UnsafeInput(byte[] buffer, int offset, int count2) {
        super(buffer, offset, count2);
    }

    public UnsafeInput(InputStream inputStream) {
        super(inputStream);
    }

    public UnsafeInput(InputStream inputStream, int bufferSize) {
        super(inputStream, bufferSize);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        return UnsafeUtil.unsafe.getByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++) & 0xFF;
    }

    @Override
    public byte readByte() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return UnsafeUtil.unsafe.getByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++);
    }

    @Override
    public int readByteUnsigned() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return UnsafeUtil.unsafe.getByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++) & 0xFF;
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        int result2 = UnsafeUtil.unsafe.getInt(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 4;
        return result2;
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        long result2 = UnsafeUtil.unsafe.getLong(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 8;
        return result2;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        float result2 = UnsafeUtil.unsafe.getFloat(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 4;
        return result2;
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        double result2 = UnsafeUtil.unsafe.getDouble(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 8;
        return result2;
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        short result2 = UnsafeUtil.unsafe.getShort(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 2;
        return result2;
    }

    @Override
    public char readChar() throws KryoException {
        this.require(2);
        char result2 = UnsafeUtil.unsafe.getChar(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position);
        this.position += 2;
        return result2;
    }

    @Override
    public boolean readBoolean() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        boolean result2 = UnsafeUtil.unsafe.getByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++) != 0;
        return result2;
    }

    @Override
    public int[] readInts(int length) throws KryoException {
        int[] array2 = new int[length];
        this.readBytes(array2, UnsafeUtil.intArrayBaseOffset, length << 2);
        return array2;
    }

    @Override
    public long[] readLongs(int length) throws KryoException {
        long[] array2 = new long[length];
        this.readBytes(array2, UnsafeUtil.longArrayBaseOffset, length << 3);
        return array2;
    }

    @Override
    public float[] readFloats(int length) throws KryoException {
        float[] array2 = new float[length];
        this.readBytes(array2, UnsafeUtil.floatArrayBaseOffset, length << 2);
        return array2;
    }

    @Override
    public double[] readDoubles(int length) throws KryoException {
        double[] array2 = new double[length];
        this.readBytes(array2, UnsafeUtil.doubleArrayBaseOffset, length << 3);
        return array2;
    }

    @Override
    public short[] readShorts(int length) throws KryoException {
        short[] array2 = new short[length];
        this.readBytes(array2, UnsafeUtil.shortArrayBaseOffset, length << 1);
        return array2;
    }

    @Override
    public char[] readChars(int length) throws KryoException {
        char[] array2 = new char[length];
        this.readBytes(array2, UnsafeUtil.charArrayBaseOffset, length << 1);
        return array2;
    }

    @Override
    public boolean[] readBooleans(int length) throws KryoException {
        boolean[] array2 = new boolean[length];
        this.readBytes(array2, UnsafeUtil.booleanArrayBaseOffset, length);
        return array2;
    }

    @Override
    public void readBytes(byte[] bytes, int offset, int count2) throws KryoException {
        this.readBytes((Object)bytes, UnsafeUtil.byteArrayBaseOffset + (long)offset, count2);
    }

    public void readBytes(Object to, long offset, int count2) throws KryoException {
        int copyCount = Math.min(this.limit - this.position, count2);
        while (true) {
            UnsafeUtil.unsafe.copyMemory(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, to, offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += (long)copyCount;
            copyCount = Math.min(count2, this.capacity);
            this.require(copyCount);
        }
    }
}

