/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.ImmutableSerializer;

public class EnumNameSerializer
extends ImmutableSerializer<Enum> {
    private final Class<? extends Enum> enumType;

    public EnumNameSerializer(Class<? extends Enum> enumType) {
        this.enumType = enumType;
    }

    @Override
    public void write(Kryo kryo, Output output, Enum object) {
        output.writeString(object.name());
    }

    @Override
    public Enum read(Kryo kryo, Input input, Class type) {
        String name2 = input.readString();
        try {
            return Enum.valueOf(this.enumType, name2);
        }
        catch (IllegalArgumentException ex) {
            throw new KryoException("Enum value not found with name: " + name2, ex);
        }
    }
}

