/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.ArtProfileSerializer;
import com.android.tools.profgen.DexDataKt;
import com.android.tools.profgen.DexFile;
import com.android.tools.profgen.DexFileData;
import com.android.tools.profgen.DexHeader;
import com.android.tools.profgen.DexMethod;
import com.android.tools.profgen.MetadataVersion;
import com.android.tools.profgen.MethodData;
import com.android.tools.profgen.ObfuscationMap;
import com.android.tools.profgen.Span;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u001dJ\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000b\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\f\u001a\u00020\u001eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/profgen/ArtProfile;", "", "profileData", "", "Lcom/android/tools/profgen/DexFile;", "Lcom/android/tools/profgen/DexFileData;", "apkName", "", "(Ljava/util/Map;Ljava/lang/String;)V", "getProfileData", "()Ljava/util/Map;", "addMetadata", "other", "version", "Lcom/android/tools/profgen/MetadataVersion;", "extractKey", "key", "nonEmptySpan", "Lcom/android/tools/profgen/Span;", "first", "second", "print", "", "os", "Ljava/io/PrintStream;", "obf", "Lcom/android/tools/profgen/ObfuscationMap;", "save", "Ljava/io/OutputStream;", "Lcom/android/tools/profgen/ArtProfileSerializer;", "Lcom/android/tools/profgen/DexHeader;", "unnamed"})
@SourceDebugExtension(value={"SMAP\nArtProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtProfile.kt\ncom/android/tools/profgen/ArtProfile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1855#2,2:291\n*S KotlinDebug\n*F\n+ 1 ArtProfile.kt\ncom/android/tools/profgen/ArtProfile\n*L\n34#1:291,2\n*E\n"})
public final class ArtProfile {
    @NotNull
    private final Map<DexFile, DexFileData> profileData;
    @NotNull
    private final String apkName;

    public ArtProfile(@NotNull Map<DexFile, DexFileData> profileData, @NotNull String apkName) {
        Intrinsics.checkNotNullParameter(profileData, (String)"profileData");
        Intrinsics.checkNotNullParameter((Object)apkName, (String)"apkName");
        this.profileData = profileData;
        this.apkName = apkName;
    }

    public /* synthetic */ ArtProfile(Map map, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(map, string);
    }

    @NotNull
    public final Map<DexFile, DexFileData> getProfileData() {
        return this.profileData;
    }

    public final void print(@NotNull PrintStream os, @NotNull ObfuscationMap obf) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)obf, (String)"obf");
        for (Map.Entry<DexFile, DexFileData> entry : this.profileData.entrySet()) {
            DexFile dexFile = entry.getKey();
            DexFileData data = entry.getValue();
            Iterator<Object> iterator2 = data.getTypeIndexes().iterator();
            while (iterator2.hasNext()) {
                String type;
                int n = ((Number)iterator2.next()).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)dexFile.getTypePool$unnamed().get(n), (String)"dexFile.typePool[typeIndex]");
                Iterable $this$forEach$iv = obf.deobfuscate$unnamed(type);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    os.println(it);
                }
            }
            for (Map.Entry entry2 : data.getMethods().entrySet()) {
                DexMethod method;
                int methodIndex = ((Number)entry2.getKey()).intValue();
                MethodData methodData2 = (MethodData)entry2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)dexFile.getMethodPool$unnamed().get(methodIndex), (String)"dexFile.methodPool[methodIndex]");
                DexMethod deobfuscated = obf.deobfuscate$unnamed(method);
                methodData2.print(os);
                deobfuscated.print(os);
                os.println();
            }
        }
    }

    public final void save(@NotNull OutputStream os, @NotNull ArtProfileSerializer version) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        OutputStream $this$save_u24lambda_u241 = os;
        boolean bl = false;
        $this$save_u24lambda_u241.write(version.getMagicBytes$unnamed());
        $this$save_u24lambda_u241.write(version.getVersionBytes$unnamed());
        version.write$unnamed(os, this.profileData, this.apkName);
    }

    @NotNull
    public final ArtProfile addMetadata(@NotNull ArtProfile other, @NotNull MetadataVersion version) {
        Map map;
        String key;
        DexFileData value;
        DexFile file;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Set keys = new LinkedHashSet();
        Map files = new LinkedHashMap();
        Map outFiles = new LinkedHashMap();
        Map outValues = new LinkedHashMap();
        for (Map.Entry<DexFile, DexFileData> object : this.profileData.entrySet()) {
            file = object.getKey();
            value = object.getValue();
            key = this.extractKey(file.getName());
            ((Collection)keys).add(key);
            files.put(key, file);
            outValues.put(key, value);
        }
        for (Map.Entry<DexFile, DexFileData> entry : other.profileData.entrySet()) {
            file = entry.getKey();
            value = entry.getValue();
            key = this.extractKey(file.getName());
            ((Collection)keys).add(key);
            DexFile source = (DexFile)files.get(key);
            map = outFiles;
            Pair pair = source != null ? TuplesKt.to((Object)key, (Object)this.addMetadata(source, file, version)) : TuplesKt.to((Object)key, (Object)file);
            map.put(pair.getFirst(), pair.getSecond());
            outValues.put(key, DexDataKt.plus(value, (DexFileData)outValues.get(key)));
        }
        Map combinedMap = new LinkedHashMap();
        for (String key2 : keys) {
            DexFile file2 = (DexFile)outFiles.get(key2);
            DexFileData value2 = (DexFileData)outValues.get(key2);
            if (file2 == null || value2 == null) continue;
            Map map2 = combinedMap;
            map = TuplesKt.to((Object)file2, (Object)value2);
            map2.put(map.getFirst(), map.getSecond());
        }
        return new ArtProfile(combinedMap, this.apkName);
    }

    private final String extractKey(String key) {
        boolean bl;
        String result = StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)key, (char)'!', null, (int)2, null), (char)':', null, (int)2, null);
        boolean bl2 = bl = StringsKt.indexOf$default((CharSequence)result, (char)':', (int)0, (boolean)false, (int)6, null) == -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = StringsKt.indexOf$default((CharSequence)result, (char)'!', (int)0, (boolean)false, (int)6, null) == -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return result;
    }

    private final DexFile addMetadata(DexFile $this$addMetadata, DexFile other, MetadataVersion version) {
        DexFile dexFile;
        switch (WhenMappings.$EnumSwitchMapping$0[version.ordinal()]) {
            case 1: {
                dexFile = $this$addMetadata;
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)$this$addMetadata.getName(), (Object)other.getName())) {
                    DexHeader dexHeader = this.addMetadata($this$addMetadata.getHeader$unnamed(), other.getHeader$unnamed());
                    String string = $this$addMetadata.getName();
                    long l = $this$addMetadata.getDexChecksum();
                    dexFile = new DexFile(dexHeader, l, string);
                    break;
                }
                dexFile = $this$addMetadata;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dexFile;
    }

    private final DexHeader addMetadata(DexHeader $this$addMetadata, DexHeader other) {
        return new DexHeader(this.nonEmptySpan($this$addMetadata.getStringIds(), other.getStringIds()), this.nonEmptySpan($this$addMetadata.getTypeIds(), other.getTypeIds()), this.nonEmptySpan($this$addMetadata.getPrototypeIds(), other.getPrototypeIds()), this.nonEmptySpan($this$addMetadata.getMethodIds(), other.getMethodIds()), this.nonEmptySpan($this$addMetadata.getClassDefs(), other.getClassDefs()), this.nonEmptySpan($this$addMetadata.getData(), other.getData()));
    }

    private final Span nonEmptySpan(Span first, Span second) {
        if (!Intrinsics.areEqual((Object)first, (Object)Span.Companion.getEmpty())) {
            return first;
        }
        return second;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetadataVersion.values().length];
            try {
                nArray[MetadataVersion.V_001.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetadataVersion.V_002.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

