/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.apk.analyzer.internal.SigUtils;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardUsagesMap;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedField;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedFieldReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedTypeReference;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableFieldReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodReference;
import com.android.tools.smali.dexlib2.util.ReferenceUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;

public class PackageTreeCreator {
    public static final String PARAMS_DELIMITER = ",";
    private final ProguardMap proguardMap;
    private final ProguardUsagesMap usagesMap;

    public PackageTreeCreator(ProguardMappings proguardMappings, boolean deobfuscateNames) {
        this.proguardMap = deobfuscateNames && proguardMappings != null ? proguardMappings.map : null;
        this.usagesMap = proguardMappings == null ? null : proguardMappings.usage;
    }

    private static Multimap<String, MethodReference> getAllMethodReferencesByClassName(DexBackedDexFile dexFile) {
        ArrayListMultimap methodsByClass = ArrayListMultimap.create();
        int m = dexFile.getMethodSection().size();
        for (int i = 0; i < m; ++i) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i);
            methodsByClass.put((Object)methodRef.getDefiningClass(), (Object)methodRef);
        }
        return methodsByClass;
    }

    private static Multimap<String, FieldReference> getAllFieldReferencesByClassName(DexBackedDexFile dexFile) {
        ArrayListMultimap fieldsByClass = ArrayListMultimap.create();
        int m = dexFile.getFieldSection().size();
        for (int i = 0; i < m; ++i) {
            DexBackedFieldReference fieldRef = new DexBackedFieldReference(dexFile, i);
            fieldsByClass.put((Object)fieldRef.getDefiningClass(), (Object)fieldRef);
        }
        return fieldsByClass;
    }

    private static Map<String, TypeReference> getAllTypeReferencesByClassName(DexBackedDexFile dexFile) {
        HashMap<String, TypeReference> typesByName = new HashMap<String, TypeReference>();
        int m = dexFile.getTypeSection().size();
        for (int i = 0; i < m; ++i) {
            DexBackedTypeReference typeRef = new DexBackedTypeReference(dexFile, i);
            typesByName.put(typeRef.getType(), (TypeReference)typeRef);
        }
        return typesByName;
    }

    public DexPackageNode constructPackageTree(Map<Path, DexBackedDexFile> dexFiles) {
        DexPackageNode root = new DexPackageNode("root", null);
        for (Map.Entry<Path, DexBackedDexFile> dexFile : dexFiles.entrySet()) {
            this.constructPackageTree(root, dexFile.getKey(), dexFile.getValue());
        }
        return root;
    }

    public DexPackageNode constructPackageTree(DexBackedDexFile dexFile) {
        DexPackageNode root = new DexPackageNode("root", null);
        this.constructPackageTree(root, null, dexFile);
        return root;
    }

    public void constructPackageTree(DexPackageNode root, Path dexFilePath, DexBackedDexFile dexFile) {
        String cleanClassName;
        Object classNode;
        TypeReference typeRef;
        Multimap<String, MethodReference> methodRefsByClassName = PackageTreeCreator.getAllMethodReferencesByClassName(dexFile);
        Multimap<String, FieldReference> fieldRefsByClassName = PackageTreeCreator.getAllFieldReferencesByClassName(dexFile);
        Map<String, TypeReference> typeRefsByName = PackageTreeCreator.getAllTypeReferencesByClassName(dexFile);
        for (DexBackedClassDef classDef : dexFile.getClasses()) {
            for (DexBackedMethod method : classDef.getMethods()) {
                methodRefsByClassName.remove((Object)classDef.getType(), (Object)method);
            }
            for (DexBackedField field : classDef.getFields()) {
                fieldRefsByClassName.remove((Object)classDef.getType(), (Object)field);
            }
        }
        for (DexBackedClassDef classDef : dexFile.getClasses()) {
            typeRef = typeRefsByName.get(classDef.getType());
            String className = PackageTreeCreator.decodeClassName(classDef.getType(), this.proguardMap);
            classNode = root.getOrCreateClass("", className, typeRef);
            ((DefaultMutableTreeNode)classNode).setUserObject(dexFilePath);
            ((DexElementNode)classNode).setDefined(true);
            ((DexClassNode)classNode).setSize(((DexClassNode)classNode).getSize() + (long)classDef.getSize());
            this.addMethods((DexClassNode)classNode, classDef.getMethods(), dexFilePath);
            this.addFields((DexClassNode)classNode, classDef.getFields(), dexFilePath);
        }
        for (Object className : methodRefsByClassName.keySet()) {
            typeRef = typeRefsByName.get(className);
            cleanClassName = PackageTreeCreator.decodeClassName((String)className, this.proguardMap);
            classNode = root.getOrCreateClass("", cleanClassName, typeRef);
            this.addMethods((DexClassNode)classNode, methodRefsByClassName.get(className), dexFilePath);
        }
        for (Object className : fieldRefsByClassName.keySet()) {
            typeRef = typeRefsByName.get(className);
            cleanClassName = PackageTreeCreator.decodeClassName((String)className, this.proguardMap);
            classNode = root.getOrCreateClass("", cleanClassName, typeRef);
            this.addFields((DexClassNode)classNode, fieldRefsByClassName.get(className), dexFilePath);
        }
        if (this.usagesMap != null) {
            for (Object className : this.usagesMap.getClasses()) {
                DexClassNode classNode2 = root.getOrCreateClass("", (String)className, null);
                classNode2.setDefined(false);
                classNode2.setRemoved(true);
            }
            Multimap removedMethodsByClass = this.usagesMap.getMethodsByClass();
            for (String className : removedMethodsByClass.keySet()) {
                DexClassNode classNode3 = root.getOrCreateClass("", className, null);
                for (String removedMethodName : removedMethodsByClass.get((Object)className)) {
                    DexMethodNode methodNode = new DexMethodNode(removedMethodName, null);
                    methodNode.setDefined(false);
                    methodNode.setRemoved(true);
                    classNode3.add(methodNode);
                }
            }
            Multimap removedFieldsByClass = this.usagesMap.getFieldsByClass();
            for (String className : removedFieldsByClass.keySet()) {
                classNode = root.getOrCreateClass("", className, null);
                for (String removedFieldName : removedFieldsByClass.get((Object)className)) {
                    DexFieldNode fieldNode = new DexFieldNode(removedFieldName, null);
                    fieldNode.setDefined(false);
                    fieldNode.setRemoved(true);
                    ((DefaultMutableTreeNode)classNode).add(fieldNode);
                }
            }
        }
        root.update();
        root.sort(Comparator.comparing(DexElementNode::getMethodReferencesCount).reversed());
    }

    private void addMethods(DexClassNode classNode, Iterable<? extends MethodReference> methodRefs, Path dexFilePath) {
        for (MethodReference methodReference : methodRefs) {
            DexMethodNode methodNode;
            String methodName = PackageTreeCreator.decodeMethodName(methodReference, this.proguardMap);
            String returnType = PackageTreeCreator.decodeClassName(methodReference.getReturnType(), this.proguardMap);
            String params = PackageTreeCreator.decodeMethodParams(methodReference, this.proguardMap);
            String methodSig = returnType + " " + methodName + params;
            if (methodSig.startsWith("void <init>") || methodSig.startsWith("void <clinit>")) {
                methodSig = methodName + params;
            }
            if ((methodNode = classNode.getChildByType(methodSig, DexMethodNode.class)) == null) {
                methodNode = new DexMethodNode(methodSig, ImmutableMethodReference.of((MethodReference)methodReference));
                classNode.add(methodNode);
            }
            if (methodReference instanceof DexBackedMethod) {
                methodNode.setDefined(true);
                methodNode.setUserObject(dexFilePath);
                methodNode.setSize(methodNode.getSize() + (long)((DexBackedMethod)methodReference).getSize());
                continue;
            }
            if (!(methodReference instanceof DexBackedMethodReference)) continue;
            methodNode.setSize(methodNode.getSize() + (long)((DexBackedMethodReference)methodReference).getSize());
        }
    }

    private void addFields(DexClassNode classNode, Iterable<? extends FieldReference> fieldRefs, Path dexFilePath) {
        for (FieldReference fieldReference : fieldRefs) {
            String fieldName = PackageTreeCreator.decodeFieldName(fieldReference, this.proguardMap);
            String fieldType = PackageTreeCreator.decodeClassName(fieldReference.getType(), this.proguardMap);
            String fieldSig = fieldType + " " + fieldName;
            DexFieldNode fieldNode = classNode.getChildByType(fieldSig, DexFieldNode.class);
            if (fieldNode == null) {
                fieldNode = new DexFieldNode(fieldSig, ImmutableFieldReference.of((FieldReference)fieldReference));
                classNode.add(fieldNode);
            }
            if (fieldReference instanceof DexBackedField) {
                fieldNode.setDefined(true);
                fieldNode.setUserObject(dexFilePath);
                fieldNode.setSize(fieldNode.getSize() + (long)((DexBackedField)fieldReference).getSize());
                continue;
            }
            if (!(fieldReference instanceof DexBackedFieldReference)) continue;
            fieldNode.setSize(fieldNode.getSize() + (long)((DexBackedFieldReference)fieldReference).getSize());
        }
    }

    public static String decodeFieldName(FieldReference fieldRef, ProguardMap proguardMap) {
        String fieldName = fieldRef.getName();
        if (proguardMap != null) {
            String className = PackageTreeCreator.decodeClassName(fieldRef.getDefiningClass(), proguardMap);
            fieldName = proguardMap.getFieldName(className, fieldName);
        }
        return fieldName;
    }

    public static String decodeMethodParams(MethodReference methodRef, ProguardMap proguardMap) {
        Stream<String> params = methodRef.getParameterTypes().stream().map(String::valueOf).map(SigUtils::signatureToName);
        if (proguardMap != null) {
            params = params.map(arg_0 -> ((ProguardMap)proguardMap).getClassName(arg_0));
        }
        return "(" + params.collect(Collectors.joining(PARAMS_DELIMITER)) + ")";
    }

    public static String decodeMethodName(MethodReference methodRef, ProguardMap proguardMap) {
        if (proguardMap != null) {
            String className = proguardMap.getClassName(SigUtils.signatureToName(methodRef.getDefiningClass()));
            String methodName = methodRef.getName();
            String sigWithoutName = ReferenceUtil.getMethodDescriptor((MethodReference)methodRef, (boolean)true).substring(methodName.length());
            ProguardMap.Frame frame = proguardMap.getFrame(className, methodName, sigWithoutName, null, -1);
            return frame.methodName;
        }
        return methodRef.getName();
    }

    public static String decodeClassName(String className, ProguardMap proguardMap) {
        className = SigUtils.signatureToName(className);
        if (proguardMap != null) {
            className = proguardMap.getClassName(className);
        }
        return className;
    }
}

