/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.client.api.LintClient;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LintExternalAnnotationsManager
extends BaseExternalAnnotationsManager {
    public static final String SDK_ANNOTATIONS_PATH = "annotations.zip";
    private final List<VirtualFile> roots = Lists.newArrayList();

    public LintExternalAnnotationsManager(Project project, PsiManager psiManager) {
        super(psiManager);
    }

    protected boolean hasAnyAnnotationsRoots() {
        return !this.roots.isEmpty();
    }

    protected List<VirtualFile> getExternalAnnotationsRoots(VirtualFile virtualFile) {
        return this.roots;
    }

    public void updateAnnotationRoots(LintClient client, IAndroidTarget target, boolean nonAndroid) {
        Collection projects = client.getKnownProjects();
        File sdkAnnotations = LintExternalAnnotationsManager.findSdkAnnotations(client, target, nonAndroid);
        List libraryAnnotations = client.getExternalAnnotations(projects);
        this.updateAnnotationRoots(sdkAnnotations, libraryAnnotations);
    }

    public boolean hasConfiguredAnnotationRoot(PsiModifierListOwner owner) {
        return false;
    }

    private static File findSdkAnnotations(LintClient client, IAndroidTarget target, boolean nonAndroid) {
        Path file;
        File sdkAnnotations;
        if (nonAndroid) {
            return null;
        }
        String path = System.getenv("SDK_ANNOTATIONS");
        if (path != null && (sdkAnnotations = new File(path)).exists()) {
            return sdkAnnotations;
        }
        if (target != null && target.isPlatform() && target.getVersion().getFeatureLevel() >= 26 && Files.isRegularFile(file = target.getPath(7).resolve(SDK_ANNOTATIONS_PATH), new LinkOption[0])) {
            return file.toFile();
        }
        return client.findResource(SDK_ANNOTATIONS_PATH);
    }

    private void updateAnnotationRoots(File sdkAnnotations, List<File> libraryAnnotations) {
        List<File> files;
        if (sdkAnnotations != null) {
            if (libraryAnnotations.isEmpty()) {
                files = Collections.singletonList(sdkAnnotations);
            } else {
                files = new ArrayList<File>(libraryAnnotations);
                files.add(sdkAnnotations);
            }
        } else {
            files = libraryAnnotations;
        }
        ArrayList<VirtualFile> newRoots = new ArrayList<VirtualFile>(files.size());
        VirtualFileSystem local = StandardFileSystems.local();
        VirtualFileSystem jar = StandardFileSystems.jar();
        for (File file : files) {
            boolean isZip = file.getName().equals(SDK_ANNOTATIONS_PATH);
            VirtualFile virtualFile = isZip ? jar.findFileByPath(file.getPath() + "!/") : local.findFileByPath(file.getPath());
            if (virtualFile == null) {
                virtualFile = isZip ? jar.findFileByPath(file.getAbsolutePath() + "!/") : local.findFileByPath(file.getAbsolutePath());
            }
            if (virtualFile == null) continue;
            newRoots.add(virtualFile);
        }
        if (this.roots.containsAll(newRoots)) {
            return;
        }
        this.roots.addAll(newRoots);
        this.dropCache();
    }
}

