/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponent;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004-./0B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u0004\u0018\u00010\u00122\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020&H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020&H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020+H\u0016J\u000e\u0010,\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;)V", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "state", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "ensureConsistent", "", "files", "", "getAllFirFiles", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFirCallableContainerFile", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFile", "getFirClassifierContainerFileIfAny", "getFirFilesByPackage", "getFirScriptContainerFile", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "recordFile", "FirRecorder", "FirRecorderData", "State", "SymbolProvider", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl\n+ 2 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 3 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n96#2:332\n90#2:333\n78#2:334\n84#2:336\n36#3:335\n1313#4,2:337\n1855#5,2:339\n1549#5:341\n1620#5,3:342\n1549#5:345\n1620#5,3:346\n1855#5,2:349\n1855#5,2:351\n*S KotlinDebug\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl\n*L\n26#1:332\n26#1:333\n26#1:334\n26#1:336\n26#1:335\n114#1:337,2\n252#1:339,2\n265#1:341\n265#1:342,3\n279#1:345\n279#1:346,3\n295#1:349,2\n297#1:351,2\n*E\n"})
public final class FirProviderImpl
extends FirProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirKotlinScopeProvider kotlinScopeProvider;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final State state;

    public FirProviderImpl(@NotNull FirSession session2, @NotNull FirKotlinScopeProvider kotlinScopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider2, (String)"kotlinScopeProvider");
        this.session = session2;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        this.symbolProvider = new SymbolProvider();
        this.state = new State();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirKotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    @Override
    @NotNull
    public FirSymbolProvider getSymbolProvider() {
        return this.symbolProvider;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        $this$originalIfFakeOverride$iv = symbol;
        $i$f$originalIfFakeOverride = false;
        $this$originalIfFakeOverride$iv$iv = (FirCallableDeclaration)$this$originalIfFakeOverride$iv.getFir();
        $i$f$originalIfFakeOverride = false;
        $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
        $i$f$getOriginalForSubstitutionOverride = false;
        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv)) ** GOTO lbl-1000
        $this$isSynthetic$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv;
        $i$f$isSynthetic = false;
        if (Intrinsics.areEqual((Object)$this$isSynthetic$iv$iv$iv$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) lbl-1000:
        // 2 sources

        {
            v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv);
        } else {
            v0 = v1 = null;
        }
        if (v0 == null) {
            $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
            $i$f$getBaseForIntersectionOverride = false;
            v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
        }
        v2 = var2_12 = v1 != null ? v1.getSymbol() : null;
        if (var2_12 != null) {
            originalSymbol = var2_12;
            $i$a$-let-FirProviderImpl$getFirCallableContainerFile$1 = false;
            return FirProviderKt.getFirProvider(originalSymbol.getModuleData().getSession()).getFirCallableContainerFile(originalSymbol);
        }
        if (symbol instanceof FirBackingFieldSymbol) {
            return this.getFirCallableContainerFile(((FirBackingField)((FirBackingFieldSymbol)symbol).getFir()).getPropertySymbol());
        }
        if (symbol instanceof FirSyntheticPropertySymbol && (fir = (FirProperty)((FirSyntheticPropertySymbol)symbol).getFir()) instanceof FirSyntheticProperty) {
            return this.getFirCallableContainerFile(((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol());
        }
        return this.state.getCallableContainerMap().get(symbol);
    }

    @Override
    @Nullable
    public FirFile getFirScriptContainerFile(@NotNull FirScriptSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.state.getScriptContainerMap().get(symbol2);
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirFile firFile = this.state.getClassifierContainerFileMap().get(fqName2);
        if (firFile == null) {
            throw new IllegalStateException(("Couldn't find container for " + fqName2).toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.state.getClassifierContainerFileMap().get(fqName2);
    }

    public final void recordFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.recordFile(file2, this.state);
    }

    private final FirFile getFile(FirDeclaration $this$file) {
        FirFile firFile;
        FirDeclaration firDeclaration = $this$file;
        if (firDeclaration instanceof FirFile) {
            firFile = (FirFile)$this$file;
        } else if (firDeclaration instanceof FirRegularClass) {
            firFile = this.getFirClassifierContainerFile(((FirRegularClass)$this$file).getSymbol().getClassId());
        } else {
            throw new IllegalStateException("Should not be here".toString());
        }
        return firFile;
    }

    /*
     * WARNING - void declaration
     */
    private final void recordFile(FirFile file2, State state) {
        void $this$forEach$iv;
        FqName packageName2 = UtilsKt.getPackageFqName(file2);
        state.getFileMap().merge(packageName2, CollectionsKt.listOf((Object)file2), (arg_0, arg_1) -> FirProviderImpl.recordFile$lambda$1(recordFile.1.INSTANCE, arg_0, arg_1));
        Sequence sequence2 = SequencesKt.generateSequence((Object)packageName2, (Function1)recordFile.2.INSTANCE);
        Set<FqName> set = state.getAllSubPackages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName p0 = (FqName)element$iv;
            boolean bl = false;
            set.add(p0);
        }
        file2.acceptChildren(FirRecorder.INSTANCE, new FirRecorderData(state, file2, FirNameConflictsTrackerComponentKt.getNameConflictsTracker(this.session)));
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        List list2 = this.state.getFileMap().get(fqName2);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (!(!classId.isLocal())) {
            boolean bl = false;
            String string2 = "Local " + classId + " should never be used to find its corresponding classifier";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.state.getClassifierMap().get(classId);
    }

    public final void ensureConsistent(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        State newState = new State();
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl = false;
            this.recordFile(it, newState);
        }
        List failures = new ArrayList();
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "fileMap", this.state.getFileMap(), newState.getFileMap());
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "classifierMap", this.state.getClassifierMap(), newState.getClassifierMap(), null, 16, null);
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "classifierContainerFileMap", this.state.getClassifierContainerFileMap(), newState.getClassifierContainerFileMap(), null, 16, null);
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getFunctionMap(), newState.getFunctionMap());
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getPropertyMap(), newState.getPropertyMap());
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getConstructorMap(), newState.getConstructorMap());
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "callableContainerMap", this.state.getCallableContainerMap(), newState.getCallableContainerMap(), null, 16, null);
        this.state.setFrom(newState);
    }

    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Set set = this.state.getClassesInPackage().get(fqName2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final List<FirFile> getAllFirFiles() {
        return CollectionsKt.flatten((Iterable)this.state.getFileMap().values());
    }

    private static final List recordFile$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final <K, V> void ensureConsistent$checkMapDiff(List<String> failures, String title, Map<K, ? extends V> a, Map<K, ? extends V> b, Function2<? super V, ? super V, Boolean> equal) {
        void $this$mapTo$iv$iv;
        boolean hasTitle = false;
        Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
        Iterable $this$map$iv = unionKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triple((Object)it, a.get(it), b.get(it)));
        }
        for (Triple triple : (List)destination$iv$iv) {
            Object bValue;
            Object key = triple.component1();
            Object aValue = triple.component2();
            if (((Boolean)equal.invoke(aValue, bValue = triple.component3())).booleanValue()) continue;
            if (!hasTitle) {
                ((Collection)failures).add(title);
                hasTitle = true;
            }
            ((Collection)failures).add("diff at key = '" + key + "': was: '" + aValue + "', become: '" + bValue + '\'');
        }
    }

    static /* synthetic */ void ensureConsistent$checkMapDiff$default(List list2, String string2, Map map, Map map2, Function2 function2, int n, Object object) {
        if ((n & 0x10) != 0) {
            function2 = ensureConsistent.checkMapDiff.1.INSTANCE;
        }
        FirProviderImpl.ensureConsistent$checkMapDiff(list2, string2, map, map2, function2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <K, V> void ensureConsistent$checkMMapDiff(List<String> failures, String title, Map<K, ? extends List<? extends V>> a, Map<K, ? extends List<? extends V>> b) {
        void $this$mapTo$iv$iv;
        boolean hasTitle = false;
        Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
        Iterable $this$map$iv = unionKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triple((Object)it, a.get(it), b.get(it)));
        }
        for (Triple triple : (List)destination$iv$iv) {
            Object it;
            Object element$iv;
            Object key = triple.component1();
            List aValue = (List)triple.component2();
            List bValue = (List)triple.component3();
            if (aValue == null || bValue == null) {
                if (!hasTitle) {
                    ((Collection)failures).add(title);
                    hasTitle = true;
                }
                ((Collection)failures).add("diff at key = '" + key + "': was: " + aValue + ", become: " + bValue);
                continue;
            }
            Set aSet = CollectionsKt.toSet((Iterable)aValue);
            Set bSet = CollectionsKt.toSet((Iterable)bValue);
            Set aLost = SetsKt.minus((Set)aSet, (Iterable)bSet);
            Set bNew = SetsKt.minus((Set)bSet, (Iterable)aSet);
            if (!(!((Collection)aLost).isEmpty()) && !(!((Collection)bNew).isEmpty())) continue;
            ((Collection)failures).add("diff at key = '" + key + "':");
            ((Collection)failures).add("    Lost:");
            Iterable $this$forEach$iv = aLost;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                it = element$iv = iterator3.next();
                boolean bl = false;
                ((Collection)failures).add("     " + it);
            }
            ((Collection)failures).add("    New:");
            $this$forEach$iv = bNew;
            $i$f$forEach = false;
            iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                it = element$iv = iterator3.next();
                boolean bl = false;
                ((Collection)failures).add("     " + it);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004JT\u0010\u0005\u001a\u00020\u0002\"\n\b\u0000\u0010\u0006\u0018\u0001*\u00020\u0007\"\u000e\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u000b\u001a\u00020\u00032\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000f0\rH\u0082\b\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorder;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorderData;", "()V", "registerCallable", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "S", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "symbol", "data", "map", "", "Lorg/jetbrains/kotlin/name/CallableId;", "", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorderData;Ljava/util/Map;)V", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitScript", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n165#1,4:353\n165#1,4:357\n165#1,4:361\n372#2,7:332\n372#2,7:339\n372#2,7:346\n1#3:365\n*S KotlinDebug\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorder\n*L\n172#1:353,4\n177#1:357,4\n182#1:361,4\n135#1:332,7\n136#1:339,7\n149#1:346,7\n*E\n"})
    private static final class FirRecorder
    extends FirDefaultVisitor<Unit, FirRecorderData> {
        @NotNull
        public static final FirRecorder INSTANCE = new FirRecorder();

        private FirRecorder() {
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull FirRecorderData data2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull FirRecorderData data2) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            ClassId classId = regularClass.getSymbol().getClassId();
            FirFile prevFile = data2.getState().getClassifierContainerFileMap().put(classId, data2.getFile());
            FirClassLikeDeclaration firClassLikeDeclaration = data2.getState().getClassifierMap().put(classId, regularClass);
            if (firClassLikeDeclaration != null) {
                FirClassLikeDeclaration it = firClassLikeDeclaration;
                boolean bl = false;
                FirNameConflictsTrackerComponent firNameConflictsTrackerComponent = data2.getNameConflictsTracker();
                if (firNameConflictsTrackerComponent != null) {
                    firNameConflictsTrackerComponent.registerClassifierRedeclaration(classId, regularClass.getSymbol(), data2.getFile(), it.getSymbol(), prevFile);
                }
            }
            if (!classId.isNestedClass() && !classId.isLocal()) {
                Object object;
                Object object2;
                Map<FqName, Set<Name>> $this$getOrPut$iv;
                Map<FqName, Set<Name>> map = data2.getState().getClassesInPackage();
                FqName fqName2 = classId.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
                FqName key$iv = fqName2;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                Set set = (Set)object2;
                Name name2 = classId.getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classId.shortClassName");
                set.add(name2);
                $this$getOrPut$iv = data2.getState().getClassifierInPackage();
                FqName fqName3 = classId.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"classId.packageFqName");
                key$iv = fqName3;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Set set2 = (Set)object;
                Name name3 = classId.getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"classId.shortClassName");
                set2.add(name3);
            }
            regularClass.acceptChildren(this, data2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull FirRecorderData data2) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            ClassId classId = typeAlias.getSymbol().getClassId();
            FirFile prevFile = data2.getState().getClassifierContainerFileMap().put(classId, data2.getFile());
            FirClassLikeDeclaration firClassLikeDeclaration = data2.getState().getClassifierMap().put(classId, typeAlias);
            if (firClassLikeDeclaration != null) {
                FirClassLikeDeclaration it = firClassLikeDeclaration;
                boolean bl = false;
                FirNameConflictsTrackerComponent firNameConflictsTrackerComponent = data2.getNameConflictsTracker();
                if (firNameConflictsTrackerComponent != null) {
                    firNameConflictsTrackerComponent.registerClassifierRedeclaration(classId, typeAlias.getSymbol(), data2.getFile(), it.getSymbol(), prevFile);
                }
            }
            Map<FqName, Set<Name>> map = data2.getState().getClassifierInPackage();
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
            FqName key$iv = fqName2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set set = (Set)object;
            Name name2 = classId.getShortClassName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classId.shortClassName");
            set.add(name2);
        }

        @Override
        public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @NotNull FirRecorderData data2) {
            Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirPropertyAccessorSymbol symbol2 = propertyAccessor.getSymbol();
            data2.getState().getCallableContainerMap().put(symbol2, data2.getFile());
        }

        private final /* synthetic */ <D extends FirCallableDeclaration, S extends FirCallableSymbol<D>> void registerCallable(S symbol2, FirRecorderData data2, Map<CallableId, List<S>> map) {
            boolean $i$f$registerCallable = false;
            CallableId callableId = symbol2.getCallableId();
            Function2 function2 = registerCallable.1.INSTANCE;
            map.merge(callableId, CollectionsKt.listOf(symbol2), new BiFunction(function2){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                    this.function = function2;
                }

                public final /* synthetic */ Object apply(Object p0, Object p1) {
                    return this.function.invoke(p0, p1);
                }
            });
            data2.getState().getCallableContainerMap().put(symbol2, data2.getFile());
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @NotNull FirRecorderData data2) {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirConstructorSymbol symbol2 = constructor2.getSymbol();
            FirRecorder firRecorder = this;
            Map<CallableId, List<FirConstructorSymbol>> map$iv = data2.getState().getConstructorMap();
            boolean $i$f$registerCallable = false;
            CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
            Function2 function2 = registerCallable.1.INSTANCE;
            map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), new /* invalid duplicate definition of identical inner class */);
            data2.getState().getCallableContainerMap().put(symbol2, data2.getFile());
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull FirRecorderData data2) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirNamedFunctionSymbol symbol2 = simpleFunction.getSymbol();
            FirRecorder firRecorder = this;
            Map<CallableId, List<FirNamedFunctionSymbol>> map$iv = data2.getState().getFunctionMap();
            boolean $i$f$registerCallable = false;
            CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
            Function2 function2 = registerCallable.1.INSTANCE;
            map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), new /* invalid duplicate definition of identical inner class */);
            data2.getState().getCallableContainerMap().put(symbol2, data2.getFile());
        }

        @Override
        public void visitProperty(@NotNull FirProperty property, @NotNull FirRecorderData data2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                FirPropertySymbol symbol2 = property.getSymbol();
                FirRecorder firRecorder = this;
                Map<CallableId, List<FirPropertySymbol>> map$iv = data2.getState().getPropertyMap();
                boolean $i$f$registerCallable = false;
                CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
                Function2 function2 = registerCallable.1.INSTANCE;
                map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), new /* invalid duplicate definition of identical inner class */);
                data2.getState().getCallableContainerMap().put(symbol2, data2.getFile());
                FirPropertyAccessor firPropertyAccessor = property.getGetter();
                if (firPropertyAccessor != null) {
                    FirPropertyAccessor it = firPropertyAccessor;
                    boolean bl = false;
                    INSTANCE.visitPropertyAccessor(it, data2);
                }
                FirPropertyAccessor firPropertyAccessor2 = property.getSetter();
                if (firPropertyAccessor2 == null) break block1;
                FirPropertyAccessor it = firPropertyAccessor2;
                boolean bl = false;
                INSTANCE.visitPropertyAccessor(it, data2);
            }
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @NotNull FirRecorderData data2) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirEnumEntrySymbol symbol2 = enumEntry.getSymbol();
            data2.getState().getCallableContainerMap().put(symbol2, data2.getFile());
        }

        @Override
        public void visitScript(@NotNull FirScript script, @NotNull FirRecorderData data2) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirScriptSymbol symbol2 = script.getSymbol();
            data2.getState().getScriptContainerMap().put(symbol2, data2.getFile());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorderData;", "", "state", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "nameConflictsTracker", "Lorg/jetbrains/kotlin/fir/FirNameConflictsTrackerComponent;", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/FirNameConflictsTrackerComponent;)V", "getFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getNameConflictsTracker", "()Lorg/jetbrains/kotlin/fir/FirNameConflictsTrackerComponent;", "getState", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "resolve"})
    private static final class FirRecorderData {
        @NotNull
        private final State state;
        @NotNull
        private final FirFile file;
        @Nullable
        private final FirNameConflictsTrackerComponent nameConflictsTracker;

        public FirRecorderData(@NotNull State state, @NotNull FirFile file2, @Nullable FirNameConflictsTrackerComponent nameConflictsTracker) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.state = state;
            this.file = file2;
            this.nameConflictsTracker = nameConflictsTracker;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        @NotNull
        public final FirFile getFile() {
            return this.file;
        }

        @Nullable
        public final FirNameConflictsTrackerComponent getNameConflictsTracker() {
            return this.nameConflictsTracker;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR#\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR#\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\rR#\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\rR#\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u001b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\rR\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\r\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "", "()V", "allSubPackages", "", "Lorg/jetbrains/kotlin/name/FqName;", "getAllSubPackages", "()Ljava/util/Set;", "callableContainerMap", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getCallableContainerMap", "()Ljava/util/Map;", "classesInPackage", "Lorg/jetbrains/kotlin/name/Name;", "getClassesInPackage", "classifierContainerFileMap", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassifierContainerFileMap", "classifierInPackage", "getClassifierInPackage", "classifierMap", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassifierMap", "constructorMap", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "getConstructorMap", "fileMap", "getFileMap", "functionMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getFunctionMap", "propertyMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getPropertyMap", "scriptContainerMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "getScriptContainerMap", "setFrom", "", "other", "resolve"})
    private static final class State {
        @NotNull
        private final Map<FqName, List<FirFile>> fileMap = new LinkedHashMap();
        @NotNull
        private final Set<FqName> allSubPackages = new LinkedHashSet();
        @NotNull
        private final Map<ClassId, FirClassLikeDeclaration> classifierMap = new LinkedHashMap();
        @NotNull
        private final Map<ClassId, FirFile> classifierContainerFileMap = new LinkedHashMap();
        @NotNull
        private final Map<FqName, Set<Name>> classifierInPackage = new LinkedHashMap();
        @NotNull
        private final Map<FqName, Set<Name>> classesInPackage = new LinkedHashMap();
        @NotNull
        private final Map<CallableId, List<FirNamedFunctionSymbol>> functionMap = new LinkedHashMap();
        @NotNull
        private final Map<CallableId, List<FirPropertySymbol>> propertyMap = new LinkedHashMap();
        @NotNull
        private final Map<CallableId, List<FirConstructorSymbol>> constructorMap = new LinkedHashMap();
        @NotNull
        private final Map<FirCallableSymbol<?>, FirFile> callableContainerMap = new LinkedHashMap();
        @NotNull
        private final Map<FirScriptSymbol, FirFile> scriptContainerMap = new LinkedHashMap();

        @NotNull
        public final Map<FqName, List<FirFile>> getFileMap() {
            return this.fileMap;
        }

        @NotNull
        public final Set<FqName> getAllSubPackages() {
            return this.allSubPackages;
        }

        @NotNull
        public final Map<ClassId, FirClassLikeDeclaration> getClassifierMap() {
            return this.classifierMap;
        }

        @NotNull
        public final Map<ClassId, FirFile> getClassifierContainerFileMap() {
            return this.classifierContainerFileMap;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getClassifierInPackage() {
            return this.classifierInPackage;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getClassesInPackage() {
            return this.classesInPackage;
        }

        @NotNull
        public final Map<CallableId, List<FirNamedFunctionSymbol>> getFunctionMap() {
            return this.functionMap;
        }

        @NotNull
        public final Map<CallableId, List<FirPropertySymbol>> getPropertyMap() {
            return this.propertyMap;
        }

        @NotNull
        public final Map<CallableId, List<FirConstructorSymbol>> getConstructorMap() {
            return this.constructorMap;
        }

        @NotNull
        public final Map<FirCallableSymbol<?>, FirFile> getCallableContainerMap() {
            return this.callableContainerMap;
        }

        @NotNull
        public final Map<FirScriptSymbol, FirFile> getScriptContainerMap() {
            return this.scriptContainerMap;
        }

        public final void setFrom(@NotNull State other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.fileMap.clear();
            this.allSubPackages.clear();
            this.classifierMap.clear();
            this.classifierContainerFileMap.clear();
            this.functionMap.clear();
            this.propertyMap.clear();
            this.constructorMap.clear();
            this.callableContainerMap.clear();
            this.scriptContainerMap.clear();
            this.fileMap.putAll(other.fileMap);
            this.allSubPackages.addAll((Collection<FqName>)other.allSubPackages);
            this.classifierMap.putAll(other.classifierMap);
            this.classifierContainerFileMap.putAll(other.classifierContainerFileMap);
            this.functionMap.putAll(other.functionMap);
            this.propertyMap.putAll(other.propertyMap);
            this.constructorMap.putAll(other.constructorMap);
            this.callableContainerMap.putAll(other.callableContainerMap);
            this.scriptContainerMap.putAll(other.scriptContainerMap);
            this.classesInPackage.putAll(other.classesInPackage);
            this.classifierInPackage.putAll(other.classifierInPackage);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0016J\u0016\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J*\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0017J&\u0010\u0016\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00170\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0017J&\u0010\u0018\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00190\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0017J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$SymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;)V", "computeCallableNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "computePackageSetWithTopLevelCallables", "", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackage", "fqName", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "knownTopLevelClassifiersInPackage", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$SymbolProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n1620#2,3:332\n1620#2,3:335\n*S KotlinDebug\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$SymbolProvider\n*L\n84#1:332,3\n87#1:335,3\n*E\n"})
    private final class SymbolProvider
    extends FirSymbolProvider {
        public SymbolProvider() {
            super(FirProviderImpl.this.getSession());
        }

        @Override
        @Nullable
        public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            FirClassLikeDeclaration firClassLikeDeclaration = FirProviderImpl.this.getFirClassifierByFqName(classId);
            return firClassLikeDeclaration != null ? firClassLikeDeclaration.getSymbol() : null;
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Collection collection = destination;
            List<FirNamedFunctionSymbol> list2 = FirProviderImpl.this.state.getFunctionMap().get(new CallableId(packageFqName, null, name2, null, 8, null));
            CollectionsKt.addAll((Collection)collection, (Iterable)(list2 != null ? (Iterable)list2 : (Iterable)CollectionsKt.emptyList()));
            collection = destination;
            List<FirPropertySymbol> list3 = FirProviderImpl.this.state.getPropertyMap().get(new CallableId(packageFqName, null, name2, null, 8, null));
            CollectionsKt.addAll((Collection)collection, (Iterable)(list3 != null ? (Iterable)list3 : (Iterable)CollectionsKt.emptyList()));
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Collection collection = destination;
            List<FirNamedFunctionSymbol> list2 = FirProviderImpl.this.state.getFunctionMap().get(new CallableId(packageFqName, null, name2, null, 8, null));
            CollectionsKt.addAll((Collection)collection, (Iterable)(list2 != null ? (Iterable)list2 : (Iterable)CollectionsKt.emptyList()));
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Collection collection = destination;
            List<FirPropertySymbol> list2 = FirProviderImpl.this.state.getPropertyMap().get(new CallableId(packageFqName, null, name2, null, 8, null));
            CollectionsKt.addAll((Collection)collection, (Iterable)(list2 != null ? (Iterable)list2 : (Iterable)CollectionsKt.emptyList()));
        }

        @Override
        @Nullable
        public FqName getPackage(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            if (FirProviderImpl.this.state.getAllSubPackages().contains(fqName2)) {
                return fqName2;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<String> computePackageSetWithTopLevelCallables() {
            void var2_2;
            void $this$mapTo$iv;
            Iterable iterable = FirProviderImpl.this.state.getAllSubPackages();
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                FqName fqName2 = (FqName)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(it.asString());
            }
            return (Set)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<String> knownTopLevelClassifiersInPackage(@NotNull FqName packageFqName) {
            void var3_3;
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Set set = FirProviderImpl.this.state.getClassifierInPackage().get(packageFqName);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Iterable iterable = set;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Name name2 = (Name)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(it.asString());
            }
            return (Set)var3_3;
        }

        @Override
        @NotNull
        public Set<Name> computeCallableNamesInPackage(@NotNull FqName packageFqName) {
            Set set;
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            FirProviderImpl firProviderImpl = FirProviderImpl.this;
            Set $this$computeCallableNamesInPackage_u24lambda_u242 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            for (CallableId key : firProviderImpl.state.getFunctionMap().keySet()) {
                if (!Intrinsics.areEqual((Object)key.getPackageName(), (Object)packageFqName)) continue;
                $this$computeCallableNamesInPackage_u24lambda_u242.add(key.getCallableName());
            }
            for (CallableId key : firProviderImpl.state.getPropertyMap().keySet()) {
                if (!Intrinsics.areEqual((Object)key.getPackageName(), (Object)packageFqName)) continue;
                $this$computeCallableNamesInPackage_u24lambda_u242.add(key.getCallableName());
            }
            return SetsKt.build((Set)set);
        }
    }
}

