/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsRuntimeAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
public final class FirJsRuntimeAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsRuntimeAnnotationChecker INSTANCE = new FirJsRuntimeAnnotationChecker();

    private FirJsRuntimeAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        for (FirAnnotation annotation2 : declaration.getAnnotations()) {
            FirClassLikeSymbol<?> annotationClassSymbol;
            if (FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation2, context.getSession()) == null || FirAnnotationHelpersKt.getExplicitAnnotationRetention(annotationClassSymbol, context.getSession()) != AnnotationRetention.RUNTIME) continue;
            if (declaration instanceof FirMemberDeclaration && FirJsHelpersKt.isEffectivelyExternal(declaration.getSymbol(), context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirJsErrors.INSTANCE.getRUNTIME_ANNOTATION_ON_EXTERNAL_DECLARATION(), (DiagnosticContext)context, null, 8, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirJsErrors.INSTANCE.getRUNTIME_ANNOTATION_NOT_SUPPORTED(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

