/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtImportOptimizer;
import org.jetbrains.kotlin.analysis.api.components.KtImportOptimizerResult;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirImportOptimizer;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirImportOptimizerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.TypeQualifier;
import org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer;", "Lorg/jetbrains/kotlin/analysis/api/components/KtImportOptimizer;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "firResolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "(Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;)V", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "getFirSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "analyseImports", "Lorg/jetbrains/kotlin/analysis/api/components/KtImportOptimizerResult;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectReferencedEntities", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer$ReferencedEntitiesResult;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "ReferencedEntitiesResult", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,468:1\n1#2:469\n551#3:470\n536#3,6:471\n*S KotlinDebug\n*F\n+ 1 KtFirImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer\n*L\n71#1:470\n71#1:471,6\n*E\n"})
public final class KtFirImportOptimizer
extends KtImportOptimizer {
    @NotNull
    private final KtLifetimeToken token;
    @NotNull
    private final LLFirResolveSession firResolveSession;

    public KtFirImportOptimizer(@NotNull KtLifetimeToken token, @NotNull LLFirResolveSession firResolveSession) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)firResolveSession, (String)"firResolveSession");
        this.token = token;
        this.firResolveSession = firResolveSession;
    }

    @Override
    @NotNull
    public KtLifetimeToken getToken() {
        return this.token;
    }

    private final FirSession getFirSession() {
        return this.firResolveSession.getUseSiteFirSession();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtImportOptimizerResult analyseImports(@NotNull KtFile file2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        FirFile firFile;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List<KtImportDirective> existingImports = file2.getImportDirectives();
        if (existingImports.isEmpty()) {
            return new KtImportOptimizerResult(SetsKt.emptySet());
        }
        FirFile $this$analyseImports_u24lambda_u240 = firFile = LowLevelFirApiFacadeKt.getOrBuildFirFile(file2, this.firResolveSession);
        boolean bl = false;
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$analyseImports_u24lambda_u240, FirResolvePhase.BODY_RESOLVE);
        FirFile firFile2 = firFile;
        Set explicitlyImportedFqNames2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)existingImports), (Function1)analyseImports.explicitlyImportedFqNames.1.INSTANCE), (Function1)analyseImports.explicitlyImportedFqNames.2.INSTANCE), (Function1)analyseImports.explicitlyImportedFqNames.3.INSTANCE));
        ReferencedEntitiesResult referencedEntitiesResult = this.collectReferencedEntities(firFile2);
        Map<FqName, Set<Name>> usedImports = referencedEntitiesResult.component1();
        Set<Name> unresolvedNames = referencedEntitiesResult.component2();
        Map<FqName, Set<Name>> map = usedImports;
        boolean $i$f$filterNot = false;
        void var11_12 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            FqName fqName2 = (FqName)entry.getKey();
            Set referencedByNames = (Set)entry.getValue();
            if (Intrinsics.areEqual((Object)FqNamesUtilKt.parentOrNull(fqName2), (Object)file2.getPackageFqName()) && referencedByNames.size() == 1) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map referencesEntities = destination$iv$iv;
        Set requiredStarImports2 = SequencesKt.toSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)referencesEntities.keySet()), (Function1)((Function1)new Function1<FqName, Boolean>((Set<FqName>)explicitlyImportedFqNames2){
            final /* synthetic */ Set<FqName> $explicitlyImportedFqNames;
            {
                this.$explicitlyImportedFqNames = $explicitlyImportedFqNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FqName it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$explicitlyImportedFqNames.contains(it);
            }
        })), (Function1)analyseImports.requiredStarImports.2.INSTANCE), (Function1)analyseImports.requiredStarImports.3.INSTANCE));
        Set unusedImports = new LinkedHashSet();
        Set alreadySeenImports = new LinkedHashSet();
        for (KtImportDirective ktImportDirective : existingImports) {
            ImportPath importPath;
            if (ktImportDirective.getImportPath() == null) continue;
            boolean isUsed = CollectionsKt.contains((Iterable)unresolvedNames, (Object)importPath.getImportedName()) ? true : (!alreadySeenImports.add(importPath) ? false : (importPath.isAllUnder() ? !((Collection)unresolvedNames).isEmpty() || requiredStarImports2.contains(importPath.getFqName()) : (referencesEntities.containsKey(importPath.getFqName()) ? CollectionsKt.contains((Iterable)((Iterable)MapsKt.getValue((Map)referencesEntities, (Object)importPath.getFqName())), (Object)importPath.getImportedName()) : false)));
            if (isUsed) continue;
            ((Collection)unusedImports).add(ktImportDirective);
        }
        return new KtImportOptimizerResult(unusedImports);
    }

    private final ReferencedEntitiesResult collectReferencedEntities(FirFile firFile) {
        Map usedImports = new LinkedHashMap();
        Set unresolvedNames = new LinkedHashSet();
        firFile.accept(new FirVisitorVoid(unresolvedNames, this, usedImports){
            final /* synthetic */ Set<Name> $unresolvedNames;
            final /* synthetic */ KtFirImportOptimizer this$0;
            final /* synthetic */ Map<FqName, Set<Name>> $usedImports;
            {
                this.$unresolvedNames = $unresolvedNames;
                this.this$0 = $receiver;
                this.$usedImports = $usedImports;
            }

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren(this);
            }

            public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                this.processFunctionCall(functionCall);
                super.visitFunctionCall(functionCall);
            }

            public void visitImplicitInvokeCall(@NotNull FirImplicitInvokeCall implicitInvokeCall) {
                Intrinsics.checkNotNullParameter((Object)implicitInvokeCall, (String)"implicitInvokeCall");
                this.processImplicitFunctionCall(implicitInvokeCall);
                super.visitImplicitInvokeCall(implicitInvokeCall);
            }

            public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
                Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                this.processPropertyAccessExpression(propertyAccessExpression);
                super.visitPropertyAccessExpression(propertyAccessExpression);
            }

            public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef) {
                Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
                this.processTypeRef(resolvedTypeRef);
                FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept(this);
                }
                super.visitTypeRef(resolvedTypeRef);
            }

            public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef) {
                Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
                this.processTypeRef(errorTypeRef);
                this.processErrorTypeRef(errorTypeRef);
                FirTypeRef firTypeRef = errorTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept(this);
                }
                super.visitErrorTypeRef(errorTypeRef);
            }

            public void visitCallableReferenceAccess(@NotNull FirCallableReferenceAccess callableReferenceAccess) {
                Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
                this.processCallableReferenceAccess(callableReferenceAccess);
                super.visitCallableReferenceAccess(callableReferenceAccess);
            }

            public void visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier) {
                Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
                this.processResolvedQualifier(resolvedQualifier);
                super.visitResolvedQualifier(resolvedQualifier);
            }

            public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier) {
                Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
                this.processResolvedQualifier(errorResolvedQualifier);
                super.visitErrorResolvedQualifier(errorResolvedQualifier);
            }

            private final void processErrorNameReference(FirResolvable resolvable) {
                FirReference firReference = resolvable.getCalleeReference();
                FirErrorNamedReference firErrorNamedReference = firReference instanceof FirErrorNamedReference ? (FirErrorNamedReference)firReference : null;
                if (firErrorNamedReference == null) {
                    return;
                }
                FirErrorNamedReference nameReference = firErrorNamedReference;
                Name name2 = KtFirImportOptimizerKt.access$getUnresolvedName(nameReference);
                if (name2 == null) {
                    return;
                }
                Name name3 = name2;
                ((Collection)this.$unresolvedNames).add(name3);
            }

            private final void processErrorTypeRef(FirErrorTypeRef typeRef) {
                ConeDiagnostic coneDiagnostic = typeRef.getDiagnostic();
                ConeUnresolvedError coneUnresolvedError = coneDiagnostic instanceof ConeUnresolvedError ? (ConeUnresolvedError)coneDiagnostic : null;
                if (coneUnresolvedError == null) {
                    return;
                }
                ConeUnresolvedError diagnostic = coneUnresolvedError;
                Name name2 = KtFirImportOptimizerKt.access$getUnresolvedName(diagnostic);
                if (name2 == null) {
                    return;
                }
                Name name3 = name2;
                ((Collection)this.$unresolvedNames).add(name3);
            }

            private final void processFunctionCall(FirFunctionCall functionCall) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(functionCall)) {
                    return;
                }
                this.processErrorNameReference(functionCall);
                Name name2 = KtFirImportOptimizerKt.access$getFunctionReferenceName(functionCall);
                if (name2 == null) {
                    return;
                }
                Name referencesByName = name2;
                FirCallableSymbol firCallableSymbol = KtFirImportOptimizerKt.access$getReferencedCallableSymbol(functionCall);
                if (firCallableSymbol == null) {
                    return;
                }
                FirCallableSymbol functionSymbol = firCallableSymbol;
                this.saveCallable(functionSymbol, referencesByName);
            }

            private final void processImplicitFunctionCall(FirImplicitInvokeCall implicitInvokeCall) {
                this.processErrorNameReference(implicitInvokeCall);
                FirCallableSymbol firCallableSymbol = KtFirImportOptimizerKt.access$getReferencedCallableSymbol(implicitInvokeCall);
                if (firCallableSymbol == null) {
                    return;
                }
                FirCallableSymbol functionSymbol = firCallableSymbol;
                this.saveCallable(functionSymbol, OperatorNameConventions.INVOKE);
            }

            private final void processPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(propertyAccessExpression)) {
                    return;
                }
                this.processErrorNameReference(propertyAccessExpression);
                Name name2 = KtFirImportOptimizerKt.access$getPropertyReferenceName(propertyAccessExpression);
                if (name2 == null) {
                    return;
                }
                Name referencedByName = name2;
                FirCallableSymbol firCallableSymbol = KtFirImportOptimizerKt.access$getReferencedCallableSymbol(propertyAccessExpression);
                if (firCallableSymbol == null) {
                    return;
                }
                FirCallableSymbol propertySymbol2 = firCallableSymbol;
                this.saveCallable(propertySymbol2, referencedByName);
            }

            private final void processTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedTypeRef);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(callableReferenceAccess)) {
                    return;
                }
                this.processErrorNameReference(callableReferenceAccess);
                Name name2 = KtFirImportOptimizerKt.access$getCallableReferenceName(callableReferenceAccess);
                if (name2 == null) {
                    return;
                }
                Name referencedByName = name2;
                FirCallableSymbol firCallableSymbol = KtFirImportOptimizerKt.access$getReferencedCallableSymbol(callableReferenceAccess);
                if (firCallableSymbol == null) {
                    return;
                }
                FirCallableSymbol resolvedSymbol = firCallableSymbol;
                this.saveCallable(resolvedSymbol, referencedByName);
            }

            private final void processResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedQualifier);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processTypeQualifier(TypeQualifier qualifier2) {
                TypeQualifier mostOuterTypeQualifier2 = (TypeQualifier)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)qualifier2, (Function1)collectReferencedEntities.processTypeQualifier.mostOuterTypeQualifier.1.INSTANCE));
                if (mostOuterTypeQualifier2.isQualified()) {
                    return;
                }
                this.saveType(mostOuterTypeQualifier2);
            }

            private final void saveType(TypeQualifier qualifier2) {
                FqName fqName2 = qualifier2.getReferencedClassId().asSingleFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"qualifier.referencedClassId.asSingleFqName()");
                FqName importableName = fqName2;
                Name referencedByName = qualifier2.getReferencedByName();
                this.saveReferencedItem(importableName, referencedByName);
            }

            private final void saveCallable(FirCallableSymbol<?> resolvedSymbol, Name referencedByName) {
                FqName fqName2 = FirUtilsKt.computeImportableName(resolvedSymbol, KtFirImportOptimizer.access$getFirSession(this.this$0));
                if (fqName2 == null) {
                    return;
                }
                FqName importableName = fqName2;
                this.saveReferencedItem(importableName, referencedByName);
            }

            private final void saveReferencedItem(FqName importableName, Name referencedByName) {
                Set set;
                Map<FqName, Set<Name>> $this$getOrPut$iv = this.$usedImports;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(importableName);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet<E>();
                    $this$getOrPut$iv.put(importableName, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                ((Collection)set).add(referencedByName);
            }
        });
        return new ReferencedEntitiesResult(usedImports, unresolvedNames);
    }

    public static final /* synthetic */ FirSession access$getFirSession(KtFirImportOptimizer $this) {
        return $this.getFirSession();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J5\u0010\u000f\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer$ReferencedEntitiesResult;", "", "usedImports", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "unresolvedNames", "(Ljava/util/Map;Ljava/util/Set;)V", "getUnresolvedNames", "()Ljava/util/Set;", "getUsedImports", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-api-fir"})
    private static final class ReferencedEntitiesResult {
        @NotNull
        private final Map<FqName, Set<Name>> usedImports;
        @NotNull
        private final Set<Name> unresolvedNames;

        public ReferencedEntitiesResult(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, (String)"usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            this.usedImports = usedImports;
            this.unresolvedNames = unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getUsedImports() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> getUnresolvedNames() {
            return this.unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> component1() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> component2() {
            return this.unresolvedNames;
        }

        @NotNull
        public final ReferencedEntitiesResult copy(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, (String)"usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            return new ReferencedEntitiesResult(usedImports, unresolvedNames);
        }

        public static /* synthetic */ ReferencedEntitiesResult copy$default(ReferencedEntitiesResult referencedEntitiesResult, Map map, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                map = referencedEntitiesResult.usedImports;
            }
            if ((n & 2) != 0) {
                set = referencedEntitiesResult.unresolvedNames;
            }
            return referencedEntitiesResult.copy(map, set);
        }

        @NotNull
        public String toString() {
            return "ReferencedEntitiesResult(usedImports=" + this.usedImports + ", unresolvedNames=" + this.unresolvedNames + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.usedImports).hashCode();
            result2 = result2 * 31 + ((Object)this.unresolvedNames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReferencedEntitiesResult)) {
                return false;
            }
            ReferencedEntitiesResult referencedEntitiesResult = (ReferencedEntitiesResult)other;
            if (!Intrinsics.areEqual(this.usedImports, referencedEntitiesResult.usedImports)) {
                return false;
            }
            return Intrinsics.areEqual(this.unresolvedNames, referencedEntitiesResult.unresolvedNames);
        }
    }
}

