/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.shrinker.usages;

import com.android.build.shrinker.ResourceShrinkerModel;
import com.android.build.shrinker.obfuscation.ClassAndMethod;
import com.android.build.shrinker.obfuscation.ObfuscatedClasses;
import com.android.build.shrinker.usages.AnalysisCallback;
import com.android.build.shrinker.usages.AppCompat;
import com.android.build.shrinker.usages.MethodVisitingStatus;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceType;
import com.android.tools.r8.references.MethodReference;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0016J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/android/build/shrinker/usages/DexFileAnalysisCallback;", "Lcom/android/build/shrinker/usages/AnalysisCallback;", "path", "Ljava/nio/file/Path;", "model", "Lcom/android/build/shrinker/ResourceShrinkerModel;", "(Ljava/nio/file/Path;Lcom/android/build/shrinker/ResourceShrinkerModel;)V", "isRClass", "", "()Z", "setRClass", "(Z)V", "visitingMethod", "Lcom/android/build/shrinker/usages/MethodVisitingStatus;", "getVisitingMethod", "()Lcom/android/build/shrinker/usages/MethodVisitingStatus;", "endMethodVisit", "", "methodReference", "Lcom/android/tools/r8/references/MethodReference;", "isResourceClass", "internalName", "", "isValidResourceType", "className", "referencedInt", "value", "", "referencedMethod", "methodName", "methodDescriptor", "referencedStaticField", "fieldName", "referencedString", "shouldIgnoreField", "shouldProcess", "startMethodVisit", "Companion", "shrinker"})
@SourceDebugExtension(value={"SMAP\nDexUsageRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DexUsageRecorder.kt\ncom/android/build/shrinker/usages/DexFileAnalysisCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,196:1\n1855#2,2:197\n1064#3,2:199\n1083#3,2:201\n*S KotlinDebug\n*F\n+ 1 DexUsageRecorder.kt\ncom/android/build/shrinker/usages/DexFileAnalysisCallback\n*L\n123#1:197,2\n141#1:199,2\n142#1:201,2\n*E\n"})
final class DexFileAnalysisCallback
implements AnalysisCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final ResourceShrinkerModel model;
    private boolean isRClass;
    @NotNull
    private final MethodVisitingStatus visitingMethod;
    @NotNull
    public static final String ANDROID_RES = "android_res/";

    public DexFileAnalysisCallback(@NotNull Path path, @NotNull ResourceShrinkerModel model) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.path = path;
        this.model = model;
        this.visitingMethod = new MethodVisitingStatus(false, null, 3, null);
    }

    public final boolean isRClass() {
        return this.isRClass;
    }

    public final void setRClass(boolean bl) {
        this.isRClass = bl;
    }

    @NotNull
    public final MethodVisitingStatus getVisitingMethod() {
        return this.visitingMethod;
    }

    @Override
    public boolean shouldProcess(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        this.isRClass = this.isResourceClass(internalName);
        return true;
    }

    public final boolean isResourceClass(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        String realClassName = this.model.getObfuscatedClasses().resolveOriginalClass(DexFileAnalysisCallback.Companion.toSourceClassName(internalName));
        String lastPart = StringsKt.substringAfterLast$default((String)realClassName, (char)'.', null, (int)2, null);
        if (StringsKt.startsWith$default((String)lastPart, (String)"R$", (boolean)false, (int)2, null)) {
            String string = lastPart.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String typeName = string;
            return ResourceType.fromClassName((String)typeName) != null;
        }
        return false;
    }

    @Override
    public void referencedInt(int value) {
        if (this.shouldIgnoreField()) {
            return;
        }
        ResourceUsageModel.Resource resource = this.model.getResourceStore().getResource(value);
        if (ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource)) {
            this.model.getDebugReporter().debug((Function0<String>)((Function0)new Function0<String>(resource, this){
                final /* synthetic */ ResourceUsageModel.Resource $resource;
                final /* synthetic */ DexFileAnalysisCallback this$0;
                {
                    this.$resource = $resource;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Marking " + this.$resource + " reachable: referenced from " + DexFileAnalysisCallback.access$getPath$p(this.this$0);
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void referencedStaticField(@NotNull String internalName, @NotNull String fieldName) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            if (this.shouldIgnoreField()) {
                return;
            }
            ClassAndMethod realMethod = this.model.getObfuscatedClasses().resolveOriginalMethod(new ClassAndMethod(DexFileAnalysisCallback.Companion.toSourceClassName(internalName), fieldName));
            if (!this.isValidResourceType(realMethod.getClassName())) break block3;
            String typePart = StringsKt.substringAfterLast$default((String)realMethod.getClassName(), (char)'$', null, (int)2, null);
            ResourceType resourceType = ResourceType.fromClassName((String)typePart);
            if (resourceType != null) {
                void $this$forEach$iv;
                ResourceType type = resourceType;
                boolean bl = false;
                Iterable iterable = this.model.getResourceStore().getResources(type, realMethod.getMethodName());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
                    boolean bl2 = false;
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)it);
                }
            }
        }
    }

    @Override
    public void referencedString(@NotNull String value) {
        boolean bl;
        char it;
        char element$iv;
        int n;
        block6: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (this.shouldIgnoreField()) {
                return;
            }
            if (((CharSequence)value).length() == 0 || value.length() > 80) {
                return;
            }
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            for (n = 0; n < $this$all$iv.length(); ++n) {
                it = element$iv = $this$all$iv.charAt(n);
                boolean bl2 = false;
                if (Character.isJavaIdentifierPart(it) || DexFileAnalysisCallback.referencedString$isSpecialCharacter(it)) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            boolean bl3;
            block7: {
                CharSequence $this$any$iv = value;
                boolean $i$f$any = false;
                for (n = 0; n < $this$any$iv.length(); ++n) {
                    it = element$iv = $this$any$iv.charAt(n);
                    boolean bl4 = false;
                    if (!Character.isJavaIdentifierPart(it)) continue;
                    bl3 = true;
                    break block7;
                }
                bl3 = false;
            }
            if (bl3) {
                this.model.addStringConstant(value);
                this.model.setFoundWebContent(this.model.isFoundWebContent() || StringsKt.contains$default((CharSequence)value, (CharSequence)ANDROID_RES, (boolean)false, (int)2, null));
            }
        }
    }

    @Override
    public void referencedMethod(@NotNull String internalName, @NotNull String methodName, @NotNull String methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
        if (this.isRClass && this.visitingMethod.isVisiting() && Intrinsics.areEqual((Object)this.visitingMethod.getMethodName(), (Object)"<clinit>")) {
            return;
        }
        if (Intrinsics.areEqual((Object)internalName, (Object)"android/content/res/Resources") && Intrinsics.areEqual((Object)methodName, (Object)"getIdentifier") && Intrinsics.areEqual((Object)methodDescriptor, (Object)"(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I")) {
            String string = DexFileAnalysisCallback.Companion.toSourceClassName(internalName);
            ObfuscatedClasses obfuscatedClasses = this.model.getObfuscatedClasses();
            Intrinsics.checkNotNullExpressionValue((Object)obfuscatedClasses, (String)"model.obfuscatedClasses");
            if (AppCompat.INSTANCE.isAppCompatClass$shrinker(string, obfuscatedClasses)) {
                return;
            }
            this.model.setFoundGetIdentifier(true);
        }
        if (Intrinsics.areEqual((Object)internalName, (Object)"android/webkit/WebView") && StringsKt.startsWith$default((String)methodName, (String)"load", (boolean)false, (int)2, null)) {
            this.model.setFoundWebContent(true);
        }
    }

    @Override
    public void startMethodVisit(@NotNull MethodReference methodReference) {
        Intrinsics.checkNotNullParameter((Object)methodReference, (String)"methodReference");
        this.visitingMethod.setVisiting(true);
        this.visitingMethod.setMethodName(methodReference.getMethodName());
    }

    @Override
    public void endMethodVisit(@NotNull MethodReference methodReference) {
        Intrinsics.checkNotNullParameter((Object)methodReference, (String)"methodReference");
        this.visitingMethod.setVisiting(false);
        this.visitingMethod.setMethodName(null);
    }

    private final boolean shouldIgnoreField() {
        boolean visitingFromStaticInitRClass = this.isRClass && this.visitingMethod.isVisiting() && Intrinsics.areEqual((Object)this.visitingMethod.getMethodName(), (Object)"<clinit>");
        return visitingFromStaticInitRClass || this.isRClass && !this.visitingMethod.isVisiting();
    }

    private final boolean isValidResourceType(String className) {
        return StringsKt.startsWith$default((String)StringsKt.substringAfterLast$default((String)className, (char)'.', null, (int)2, null), (String)"R$", (boolean)false, (int)2, null);
    }

    private static final boolean referencedString$isSpecialCharacter(char c) {
        return c == '.' || c == ':' || c == '/' || c == '%';
    }

    public static final /* synthetic */ Path access$getPath$p(DexFileAnalysisCallback $this) {
        return $this.path;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/shrinker/usages/DexFileAnalysisCallback$Companion;", "", "()V", "ANDROID_RES", "", "toSourceClassName", "shrinker"})
    public static final class Companion {
        private Companion() {
        }

        private final String toSourceClassName(String $this$toSourceClassName) {
            return StringsKt.replace$default((String)$this$toSourceClassName, (char)'/', (char)'.', (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

