/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.DexFileFactory;
import com.android.tools.smali.dexlib2.analysis.ClassProvider;
import com.android.tools.smali.dexlib2.analysis.DexClassProvider;
import com.android.tools.smali.dexlib2.analysis.PathEntryLoader;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedOdexFile;
import com.android.tools.smali.dexlib2.dexbacked.OatFile;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassPathResolver {
    private final Iterable<String> classPathDirs;
    private final PathEntryLoader pathEntryLoader;

    public ClassPathResolver(@Nonnull List<String> bootClassPathDirs, @Nullable List<String> bootClassPathEntries, @Nonnull List<String> extraClassPathEntries, @Nonnull MultiDexContainer.DexEntry<?> dexEntry) throws IOException {
        Object dexFile = dexEntry.getDexFile();
        this.classPathDirs = bootClassPathDirs;
        this.pathEntryLoader = new PathEntryLoader(dexEntry.getDexFile().getOpcodes());
        if (bootClassPathEntries == null) {
            bootClassPathEntries = ClassPathResolver.getDefaultBootClassPath(dexEntry, dexFile.getOpcodes().api);
        }
        for (String entry : bootClassPathEntries) {
            try {
                this.loadLocalOrDeviceBootClassPathEntry(entry);
            }
            catch (PathEntryLoader.NoDexException ex) {
                if (entry.endsWith(".jar")) {
                    String odexEntry = entry.substring(0, entry.length() - 4) + ".odex";
                    try {
                        this.loadLocalOrDeviceBootClassPathEntry(odexEntry);
                        continue;
                    }
                    catch (PathEntryLoader.NoDexException ex2) {
                        throw new ResolveException("Neither %s nor %s contain a dex file", entry, odexEntry);
                    }
                    catch (NotFoundException ex2) {
                        throw new ResolveException(ex);
                    }
                }
                throw new ResolveException(ex);
            }
            catch (NotFoundException ex) {
                if (entry.endsWith(".odex")) {
                    String jarEntry = entry.substring(0, entry.length() - 5) + ".jar";
                    try {
                        this.loadLocalOrDeviceBootClassPathEntry(jarEntry);
                        continue;
                    }
                    catch (PathEntryLoader.NoDexException ex2) {
                        throw new ResolveException("Neither %s nor %s contain a dex file", entry, jarEntry);
                    }
                    catch (NotFoundException ex2) {
                        throw new ResolveException(ex);
                    }
                }
                throw new ResolveException(ex);
            }
        }
        for (String entry : extraClassPathEntries) {
            try {
                this.loadLocalClassPathEntry(entry);
            }
            catch (PathEntryLoader.NoDexException ex) {
                throw new ResolveException(ex);
            }
        }
        MultiDexContainer<?> container = dexEntry.getContainer();
        for (String entry : container.getDexEntryNames()) {
            MultiDexContainer.DexEntry<?> tempDexEntry = container.getEntry(entry);
            assert (tempDexEntry != null);
            this.pathEntryLoader.getClassProviders().add(new DexClassProvider((DexFile)tempDexEntry.getDexFile()));
        }
    }

    public ClassPathResolver(@Nonnull List<String> bootClassPathDirs, @Nonnull List<String> extraClassPathEntries, @Nonnull MultiDexContainer.DexEntry<?> dexEntry) throws IOException {
        this(bootClassPathDirs, null, extraClassPathEntries, dexEntry);
    }

    @Nonnull
    public List<ClassProvider> getResolvedClassProviders() {
        return this.pathEntryLoader.getResolvedClassProviders();
    }

    private boolean loadLocalClassPathEntry(@Nonnull String entry) throws PathEntryLoader.NoDexException, IOException {
        File entryFile = new File(entry);
        if (entryFile.exists() && entryFile.isFile()) {
            try {
                this.pathEntryLoader.loadEntry(entryFile, true);
                return true;
            }
            catch (DexFileFactory.UnsupportedFileTypeException ex) {
                throw new ResolveException(ex, "Couldn't load classpath entry %s", entry);
            }
        }
        return false;
    }

    private void loadLocalOrDeviceBootClassPathEntry(@Nonnull String entry) throws IOException, PathEntryLoader.NoDexException, NotFoundException {
        if (this.loadLocalClassPathEntry(entry)) {
            return;
        }
        List<String> pathComponents = ClassPathResolver.splitDevicePath(entry);
        Joiner pathJoiner = Joiner.on((char)File.separatorChar);
        for (String directory : this.classPathDirs) {
            File directoryFile = new File(directory);
            if (!directoryFile.exists()) continue;
            for (int i = 0; i < pathComponents.size(); ++i) {
                String partialPath = pathJoiner.join(pathComponents.subList(i, pathComponents.size()));
                File entryFile = new File(directoryFile, partialPath);
                if (!entryFile.exists() || !entryFile.isFile()) continue;
                this.pathEntryLoader.loadEntry(entryFile, true);
                return;
            }
        }
        throw new NotFoundException("Could not find classpath entry %s", entry);
    }

    @Nonnull
    private static List<String> splitDevicePath(@Nonnull String path) {
        return Lists.newArrayList((Iterable)Splitter.on((char)'/').split((CharSequence)path));
    }

    @Nonnull
    private static List<String> getDefaultBootClassPath(@Nonnull MultiDexContainer.DexEntry<?> dexEntry, int apiLevel) {
        MultiDexContainer<?> container = dexEntry.getContainer();
        if (container instanceof OatFile) {
            return ClassPathResolver.bootClassPathForOat((OatFile)container);
        }
        Object dexFile = dexEntry.getDexFile();
        if (dexFile instanceof DexBackedOdexFile) {
            return ((DexBackedOdexFile)dexFile).getDependencies();
        }
        if (apiLevel <= 8) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar"});
        }
        if (apiLevel <= 11) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/core-junit.jar"});
        }
        if (apiLevel <= 13) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/apache-xml.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/core-junit.jar"});
        }
        if (apiLevel <= 15) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar", "/system/framework/filterfw.jar"});
        }
        if (apiLevel <= 17) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar"});
        }
        if (apiLevel <= 18) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar"});
        }
        if (apiLevel <= 19) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/conscrypt.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/framework2.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar", "/system/framework/webviewchromium.jar"});
        }
        if (apiLevel <= 22) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/apache-xml.jar"});
        }
        if (apiLevel <= 23) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/apache-xml.jar", "/system/framework/org.apache.http.legacy.boot.jar"});
        }
        return Lists.newArrayList((Object[])new String[]{"/system/framework/core-oj.jar", "/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/apache-xml.jar", "/system/framework/org.apache.http.legacy.boot.jar"});
    }

    private static List<String> bootClassPathForOat(@Nonnull OatFile oatFile) {
        List<String> bcp = oatFile.getBootClassPath();
        if (bcp.isEmpty()) {
            return Lists.newArrayList((Object[])new String[]{"boot.oat"});
        }
        return ClassPathResolver.replaceElementsSuffix(bcp, ".art", ".oat");
    }

    private static List<String> replaceElementsSuffix(List<String> bcp, String originalSuffix, String newSuffix) {
        for (int i = 0; i < bcp.size(); ++i) {
            String entry = bcp.get(i);
            if (!entry.endsWith(originalSuffix)) continue;
            bcp.set(i, entry.substring(0, entry.length() - originalSuffix.length()) + newSuffix);
        }
        return bcp;
    }

    public static class ResolveException
    extends RuntimeException {
        public ResolveException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }

        public ResolveException(Throwable cause) {
            super(cause);
        }

        public ResolveException(Throwable cause, String message, Object ... formatArgs) {
            super(String.format(message, formatArgs), cause);
        }
    }

    static class NotFoundException
    extends Exception {
        public NotFoundException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }
    }
}

